package cn.freemud.controller;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.vo.CreateSpellGroupOrderReq;
import cn.freemud.service.Orderservice;
import cn.freemud.service.SpellGroupOrderService;
import com.freemud.application.sdk.api.log.ApiAnnotation;
import com.freemud.application.sdk.api.log.LogParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author wanghanghang
 * @title: SpellGroupOrderController
 * @projectName order-group
 * @description: 拼团订单Controller
 * @date 2021/4/16上午9:50
 */
@RequestMapping("/order")
@RestController
public class SpellGroupOrderController {

    @Autowired
    private SpellGroupOrderService spellGroupOrderService;

    @ApiOperation(value = "创建拼团订单", notes = "创建拼团订单", produces = "application/json")
    @ApiAnnotation(logMessage = "createSpellGroupOrder")
    @PostMapping("/createSpellGroupOrder")
    public BaseResponse createSpellGroupOrder(@Validated @LogParams @RequestBody CreateSpellGroupOrderReq request) {
        return spellGroupOrderService.createSpellGroupOrder(request);
    }

}
