package cn.freemud.entities.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.com
 *
 * @version V1.0
 * @Description: 积分订单
 * @author: hongwang.zhang
 * @date: 2020-01-07 19:43:40
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目.
 */
@Setter
@Getter
@ToString
public class IntegralOrderVo {

    @NotEmpty(message = "图片url,不能为空")
    @ApiModelProperty(value = "图片url")
    private List<String> imgUrl;

    @NotBlank(message = "商户id 不能为空")
    @ApiModelProperty(value = "商户号")
    private String partnerId;

    @NotNull(message = "业务类型不能为空")
    @ApiModelProperty(value = "默认不填=99,订单业务类型 1:普通订单 2:虚拟订单 3:会员订单 4:积分商城订单 5:储值卡订单 6:卖券订单,97:自助录单 98:农工商停车手工录单 99:农工商停车订单")
    private Byte bizType;

    /**
     * 用户sessionId
     */
    @NotEmpty(message = "用户sessionId 不能为空")
    @ApiModelProperty(value = "用户sessionId")
    private String sessionId;


}
