package cn.freemud.controller;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.vo.*;
import cn.freemud.enums.OrderTackCodeFactory;
import cn.freemud.enums.TakeCodeOrderType;
import cn.freemud.manager.OrderTackCodeManager;
import cn.freemud.service.business.OrderBusinessService;
import cn.freemud.service.business.impl.OrderBusinessServiceImpl;
import cn.freemud.service.impl.OrderQueueService;
import cn.freemud.service.impl.OrderServiceImpl;
import cn.freemud.service.impl.PayServiceImpl;
import cn.freemud.utils.ResponseUtil;
import com.freemud.application.sdk.api.log.ApiAnnotation;
import com.freemud.application.sdk.api.log.LogParams;
import com.freemud.sdk.api.assortment.message.enums.OrderType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * 暴露订单相关的业务接口,提供给applet项目
 */
@RestController
@RequestMapping("/order/exposure")
public class ExposureOrderController {

    @Autowired
    private PayServiceImpl payService;
    @Autowired
    private OrderTackCodeManager orderTackCodeManager;

    @Autowired
    private OrderBusinessServiceImpl orderBusinessService;

    @Autowired
    private OrderServiceImpl orderService;

    @Autowired
    private OrderQueueService orderQueueService;

    /**
     * 创建支付单,查询支付配置
     */
    @ApiAnnotation(logMessage = "创建支付单,查询支付配置")
    @PostMapping("/getPayConfig")
    public BaseResponse<String> getPayConfig(@Validated @LogParams @RequestBody GetPayConfigVo getPayConfigVo) {
        String payConfig = payService.getPayConfig(getPayConfigVo.getPartnerId(), getPayConfigVo.getAppId());
        return ResponseUtil.success(payConfig);
    }

    /**
     * 创建支付单,查询超时时间
     */
    @ApiAnnotation(logMessage = "创建支付单,查询超时时间")
    @PostMapping("/getPayTimeout")
    public BaseResponse<String> getPayTimeout(@Validated @LogParams @RequestBody GetPayTimeoutVo getPayTimeoutVo) {
        String partnerPayOvertime = payService.getPartnerPayOvertime(getPayTimeoutVo.getPartnerId());
        return ResponseUtil.success(partnerPayOvertime);
    }

    /**
     * 创建支付单,查询payCode
     */
    @ApiAnnotation(logMessage = "创建支付单,查询payCode")
    @PostMapping("/getPayCodeByChanel")
    public BaseResponse<String> getPayCodeByChanel(@Validated @LogParams @RequestBody GetPayCodeByChanelVo getPayCodeByChanelVo) {

        String payCodeByCondition = payService.getPayCodeByCondition(getPayCodeByChanelVo.getAppId(), getPayCodeByChanelVo.getStoreId(), getPayCodeByChanelVo.getChannel());
        return ResponseUtil.success(payCodeByCondition);
    }

    /**
     * 创建订单,死信队列
     */
    @ApiAnnotation(logMessage = "创建订单,死信队列")
    @PostMapping("/deadLetterQueue")
    public BaseResponse deadLetterQueue(@Validated @LogParams @RequestBody PutDeadLetterVo putDeadLetterVo) {
        payService.putDelMq(putDeadLetterVo.getPartnerId(), putDeadLetterVo.getStoreId(), putDeadLetterVo.getFmId(), putDeadLetterVo.getOrderId(), putDeadLetterVo.getPayChanelType());
        return ResponseUtil.success();
    }

    /**
     * 生成取餐码
     */
    @ApiAnnotation(logMessage = "生成取餐码")
    @PostMapping("/generateTackCode")
    public BaseResponse<String> generateTackCode(@Validated @LogParams @RequestBody GenerateTackCodeVo generateTackCodeVo) {
        Integer orderTye = TakeCodeOrderType.getTakeCodeOrderType(generateTackCodeVo.getOrderType());
        String tackCode = orderTackCodeManager.generateTackCode(orderTye,
                generateTackCodeVo.getPartnerId(),
                generateTackCodeVo.getStoreId(),
                null,
                OrderTackCodeFactory.getByOrderClient(generateTackCodeVo.getOrderClient()).getGenerateTackCodeFunc());
        return ResponseUtil.success(tackCode);
    }

    /**
     * 从支付成功开始计时，超时未接单的时间（单位：分钟）
     */
    @ApiAnnotation(logMessage = "获取超时时间")
    @PostMapping("/paySuccessTimeout")
    public BaseResponse<Integer> generateTackCode(@Validated @LogParams @RequestBody GetPaySuccessTimeoutVo getPaySuccessTimeoutVo) {
        Integer tackCode = orderBusinessService.getPaySuccessTimeout(getPaySuccessTimeoutVo.getPartnerId(),
                getPaySuccessTimeoutVo.getStoreId(),
                getPaySuccessTimeoutVo.getOrderType());
        return ResponseUtil.success(tackCode);
    }

    /**
     * 发送支付成功模板消息
     */
    @ApiAnnotation(logMessage = "发送支付成功模板消息")
    @PostMapping("/sendPayTemplateMessage")
    public BaseResponse sendPayTemplateMessage(@Validated @LogParams @RequestBody SendPaySuccessMessageVo sendPaySuccessMessageVo) {
        orderService.sendMessageByNewApp(sendPaySuccessMessageVo);
        return ResponseUtil.success();
    }

    /**
     * 生成0元支付fmId
     */
    @ApiAnnotation(logMessage = "生成0元支付fmId")
    @GetMapping("/generateZeroPayFmId")
    public BaseResponse generateZeroPayFmId() {
        String fmId = payService.generateZeroPayFmId();
        return ResponseUtil.success(fmId);
    }

    /**
     * 现金支付,设置轮循队列
     */
    @ApiAnnotation(logMessage = "现金支付,设置轮循队列")
    @PostMapping("/putRoundRobin")
    public BaseResponse putRoundRobin(@Validated @LogParams @RequestBody PutRoundRobinVo putRoundRobinVo) {
        payService.putRoundRobin(putRoundRobinVo);
        return ResponseUtil.success();
    }

    /**
     * 回滚订单状态改动
     */
    @ApiAnnotation(logMessage = "回滚订单状态改动")
    @PostMapping("/backOrdersStatusChange")
    public BaseResponse backOrdersStatusChange(@Validated @LogParams @RequestBody BackOrdersStatusChangeVo backOrdersStatusChangeVo) {
        orderQueueService.backOrdersStatusChange(backOrdersStatusChangeVo.getOrderCode(), backOrdersStatusChangeVo.getOrderState());
        return ResponseUtil.success();
    }

}
