package cn.freemud.service.impl;

import cn.freemud.constant.ResponseCodeConstant;
import cn.freemud.entities.dto.ProductBaseResponse;
import cn.freemud.entities.dto.RequiredProductRequest;
import cn.freemud.entities.vo.CartGoods;
import cn.freemud.service.ProductService;
import cn.freemud.service.thirdparty.ProductClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.stream.Collectors;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: null.java
 * @Package
 * @Description: (用一句话描述该文件做什么)
 * @author: 蓝胖子(Hector)
 * @date: 2019-11-20
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目的
 */

@Service
public class ProductServiceImpl implements ProductService {

    @Autowired
    private ProductClient productClient;

    @Override
    public boolean hasRequiredProducts(String partnerId, String storeId, List<CartGoods> cartGoodsList,String menuType) {
        RequiredProductRequest request = RequiredProductRequest.builder().channel(menuType).partnerId(partnerId).shopId(storeId).build();
        ProductBaseResponse<List<String>> requiredProductList = productClient.getRequiredProductList(request);
        if (null != requiredProductList && ResponseCodeConstant.RESPONSE_SUCCESS.equals(requiredProductList.getErrcode()) &&
                !CollectionUtils.isEmpty(requiredProductList.getData())) {
            List<String> spuIds = cartGoodsList.stream().map(good -> good.getSpuId()).collect(Collectors.toList());
            // 两个集合只要没有交集，就返回true
            if (CollectionUtils.isEmpty(requiredProductList.getData().stream().filter(item -> spuIds.contains(item)).collect(Collectors.toList()))) {
                return true;
            }
        }
        return false;
    }
}
