package cn.freemud.manager;

import cn.freemud.entities.db.OpenPlatformPartnerMerchantIndirect;
import cn.freemud.manager.dao.OpenPlatformPartnerMerchantIndirectDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;


/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: OpenPlatformPartnerMerchantIndirectManager
 * @Package cn.freemud.manager
 * @Description: 简单描述下这个类是做什么用的
 * @author: hang.chai
 * @date: 2018/11/12 11:02
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Component
public class OpenPlatformPartnerMerchantIndirectManager {
    @Autowired
    private OpenPlatformPartnerMerchantIndirectDao openPlatformPartnerMerchantIndirectDao;

    /**
     * 根据商户号和支付商户号获取间联支付信息
     */
    public OpenPlatformPartnerMerchantIndirect selectMerchantIndirectByMchId(String mchId, String partnerId) {
        OpenPlatformPartnerMerchantIndirect indirect = new OpenPlatformPartnerMerchantIndirect();
        indirect.setPartnerId(partnerId);
        indirect.setMchId(mchId);
        return openPlatformPartnerMerchantIndirectDao.selectOne(indirect);
    }

    /**
     * 根据id查询间联支付配置信息
     */
    public OpenPlatformPartnerMerchantIndirect findMerchantIndirectById(String indirectId) {
        OpenPlatformPartnerMerchantIndirect indirect = new OpenPlatformPartnerMerchantIndirect();
        indirect.setIndirectId(Long.valueOf(indirectId));
        return openPlatformPartnerMerchantIndirectDao.selectOne(indirect);
    }
}
