package cn.freemud.hystrix;

import cn.freemud.entities.dto.SendShortMessageCodeDto;
import cn.freemud.entities.dto.SendSmsCodeResponseDto;
import cn.freemud.service.thirdparty.ShortMessageClient;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: ShortMessageClientFallbackFactory
 * @Package cn.freemud.hystrix
 * @Description: 熔断机制处理
 * @author: zhenghuan.yang
 * @date: 2018/6/13 9:47
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Slf4j
@Component
public class ShortMessageClientFallbackFactory implements FallbackFactory<ShortMessageClient> {
    @Override
    public ShortMessageClient create(Throwable throwable) {
        return new ShortMessageClient(){
            @Override
            public SendSmsCodeResponseDto sendSmsCode(String msappid, SendShortMessageCodeDto sendShortMessageCodeDto) {
                log.info("******************************启用熔断机制factory");
                SendSmsCodeResponseDto sendSmsCodeResponseDto=new SendSmsCodeResponseDto();
                sendSmsCodeResponseDto.setMsg("调用子服务异常，触发熔断机制");
                sendSmsCodeResponseDto.setIssuccess(false);
                return sendSmsCodeResponseDto;
            }
        };
    }
}
