package cn.freemud.enums;

public enum CouponStateEnum {
    STATE_0(0, "可用"),
    STATE_1(1, "不可用"),
    STATE_2(2, "限制可用");

    private Integer code;
    private String desc;

    CouponStateEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static CouponStateEnum getByCode(Integer code) {
        for (CouponStateEnum payType : values()) {
            if (payType.getCode().equals(code)) {
                return payType;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
