/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: ShoppingCartAddRequestVo
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: ping.wu
 * @date: 2018/5/21 19:52
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.vo;

import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.Valid;
import java.util.List;

@Data
public class ShoppingCartAddRequestVo {

    @NotEmpty(message = "sessionId不能为空")
    private String sessionId;

    @NotEmpty(message = "partnerId不能为空")
    private String partnerId;

    @NotEmpty(message = "shopId不能为空")
    private String shopId;

    private String nickName;
    /**
     * 检测是否需要校验   1 需要  0 不需要 默认是1
     */
    private Integer nickNameCheck;

    @Valid
    private List<ShoppingCartProductVo> products;

}
