/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: NearStoreResponseVo
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: ping.wu
 * @date: 2018/5/15 11:15
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.vo;

import lombok.Data;

import java.util.List;

@Data
public class NearStoreResponseVo {

    /**
     * 门店ID
     */
    private String shopId;
    /**
     * 门店名称
     */
    private String storeName;
    /**
     * 经度
     */
    private String longitude;
    /**
     * 纬度
     */
    private String latitude;
    /**
     * 电话号码
     */
    private String phone;
    //地址
    /**
     * 地址
     */
    private String address;
    //简称
    /**
     * 简称
     */
    private String briefName;
    //介绍
    /**
     * 介绍
     */
    private String remark;
    //距离
    private String distance;
    //当天营业时间
    private String businessHoursDay;
    /**
     * 当天配送时间
     */
    private String deliveryHoursDay;
    /**
     * 门店起送费
     */
    private String deliveryLimitAmount;
    /**
     * 门店是否支持外卖
     */
    private Boolean enableDelivery;
    /**
     * 门店是否支持自提
     */
    private Boolean enableCollectGoods;

    //现在是否打烊 1 正在营业 0 已经关门
    private Integer openning;

    /**
     * 门店营业 1正常  0打烊
     */
    private Integer openHour;
    /**
     * 绑定支付 1是 0否
     */
    private Integer boundPay;
    //预约时间
    private String[] appointTimes;
    //外卖送出时间
    private String[] sendAppointTimes;

    private List<StoreImagesResponseVo> imgs;

    private List<String> bannerList;

    private String city;

    private List<BannerInfo> bannerInfoList;

    @Data
    public static class BannerInfo{
        private String pictureUrl;
        private String linkUrl;
    }
}
