package cn.freemud.entities.dto;

import lombok.Data;

import java.util.List;

@Data
public class HomePageModuleDto {
    private String partnerId;
    private String appId;
    /**
     * 绑定的所有小程序appId
     */
    private String bindAppIdAll;
    private List<ModuleList> moduleList;
    @Data
    public static class ModuleList{
        /**
         * 模块id（1:一列模块，2:二列模块，3:三列模块，4:坐二右一，5:左一右二，6：轮播图模块）
         */
        private Integer moduleId;
        /**
         * 模块名称（1:一列模块，2:二列模块，3:三列模块，4:坐二右一，5:左一右二，6：轮播图模块）
         */
        private String moduleName;
        /**
         * 排序
         */
        private Integer sequence;
        /**
         * 是否显示空白间距（1：不显示，2：显示）
         */
        private Boolean spaceBetweenFlag;
        /**
         * 空白间距尺寸大小（单位px）
         */
        private Integer spaceBetweenSize;
        /**
         * 模块高度
         */
        private String moduleHeight;

        private List<PictureList> pictureList;
        @Data
        public static class PictureList{
            /**
             * 图片地址
             */
            private String pictureUrl;
            /**
             * 绑定小程序appid以及跳转地址
             */
            private String bindAppPath;
            /**
             * 绑定小程序appid
             */
            private String bindAppId;
        }
    }
    private MenuModuleDto menuModule;
}
