package cn.freemud.entities.db;

import lombok.Data;

import javax.persistence.*;
import java.util.Date;

@Data
@Table(name = "open_platform_partner_merchant_account")
public class OpenPlatformPartnerMerchantAccount {
    /**
     * 主键ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 间联支付表主键id
     */
    @Column(name = "indirect_id")
    private Long indirectId;

    /**
     * 收款账户名称
     */
    @Column(name = "account_name")
    private String accountName;

    /**
     * 收款卡号 微信对应微信号
     */
    @Column(name = "account_card")
    private String accountCard;

    /**
     * 商户ID
     */
    @Column(name = "partner_id")
    private String partnerId;

    /**
     * 支付商户号
     */
    @Column(name = "mch_id")
    private String mchId;

    /**
     * 间联渠道编号
     */
    private String platform;

    /**
     * 间联渠道名称
     */
    @Column(name = "platform_name")
    private String platformName;

    /**
     * 账户类型 1.商户 2个人微信号
     */
    @Column(name = "account_type")
    private Integer accountType;

    /**
     * 收款比例 百分比
     */
    @Column(name = "pay_rate")
    private String payRate;

    /**
     * 收款描述
     */
    @Column(name = "pay_description")
    private String payDescription;

    /**
     * 开始时间
     */
    @Column(name = "gmt_created")
    private Date gmtCreated;

    /**
     * 修改时间
     */
    @Column(name = "gmt_modified")
    private Date gmtModified;
}