package com.freemud.application.sdk.api.ordercenter.response;

import lombok.Data;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: OrderItemStatisticsResponse
 * @Package com.freemud.application.sdk.api.ordercenter.response
 * @Description:
 * @author: shuhu.hou
 * @date: 2020/4/7 16:21
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
public class OrderItemStatisticsResponse {
    /**
     * 商品
     * 组合：productName + "#split#" + productId + "#split#" +productSpecName+ "#split#"+productProperty;
     * 值：[多规格一维lulu]#split#[159339992708028675]#split#[多规格一维lulu/微辣]#split#[002之小类2/超级辣，变态辣！！]
     */
    private String aggsName;
    /**
     * 统计数量
     */
    private Double aggsSum;


    /**
     * 商品名称
     */
    public String getProductName() {
        return aggsName.split("#split#")[0].replace("[", "").replace("]", "");
    }

    /**
     * 商品编号
     */
    public String getProductId() {
        return aggsName.split("#split#")[1].replace("[", "").replace("]", "");
    }

    /**
     * 商品规格
     */
    public String getProductSpecName() {
        return aggsName.split("#split#")[2].replace("[", "").replace("]", "");
    }

}
