package com.freemud.application.sdk.api.ordercenter.request;

import com.freemud.application.sdk.api.ordercenter.request.create.DeliveryContactInfoCreateReq;
import com.freemud.application.sdk.api.ordercenter.request.create.OrderCostCreateReq;
import com.freemud.application.sdk.api.ordercenter.request.create.OrderItemCreateReq;
import com.freemud.application.sdk.api.ordercenter.request.create.OrderSettlementCreateReq;
import com.freemud.application.sdk.api.ordercenter.response.orderInfo.DeliveryContactInfoResp;
import com.freemud.application.sdk.api.ordercenter.response.orderInfo.OrderInvoice;
import com.freemud.application.sdk.api.ordercenter.response.orderInfo.OrderItemResp;
import lombok.Data;

import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.6.0
 * @Title: GroupOrderAffirmReq
 * @Description: 围餐订单完成接口
 * @author: qin.zhou
 * @date: 2019/9/311:44
 * @Copyright: ${DATE.YARE} www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
public class GroupOrderAffirmReq {
    /**
     * 商户号
     */
    private String partnerId;
    /**
     * 渠道
     */
    private Integer orderClient;

    //实际支付现金金额，扣除支付自生优惠，单位分
    private Long actualPayAmount;

    //是否需要开发票
    private boolean needInvoice;

    //订单备注
    private String note;

    //订单编号
    private String orderCode;

    //订单原始金额，单位分
    private Long originalAmount;

    //支付渠道
    private String payChannel;

    //支付渠道名称
    private String payChannelName;

    //当前支付请求号
    private String payRequestNo;

    //支付时间
    private String payTime;

    //支付类型 1:线上支付 2:线下支付
    private Integer payType;

    //pos编号
    private String posCode;

    //用户在界面上看到的支付金额
    private Long settlementAmount;

    //门店全局唯一编号
    private String storeUnifyId;

    //用户ID
    private String userId;

    //用户姓名
    private String userName;

    //就餐人数
    private Integer dinersNumber;

    //桌台号
    private String barCounter;

    //扩展字段
    private String extInfo;

    //订单费用信息
    List<OrderCostCreateReq> orderCostDetailList;

    //发票明细
    private OrderInvoice orderInvoice;

    //订单商品信息
    List<OrderItemCreateReq> orderItemList;

    //订单结算信息
    List<OrderSettlementCreateReq> orderSettlementDetailList;

    //配送联系人信息
    List<DeliveryContactInfoCreateReq> deliveryContactInfoList;

    //操作人
    private String operator;

}
