/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: CreateAfterSalesOrde
 * @Package com.freemud.application.sdk.api.ordercenter.request
 * @Description:
 * @author: ping.wu
 * @date: 2019/4/2 21:29
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package com.freemud.application.sdk.api.ordercenter.request;

import lombok.Data;

@Data
public class CreateAfterSalesOrder {

    private String partnerId;

//    订单编号，与thirdOrderCode二选一，如果orderCode为null则使用thirdOrderCode查询订单
    private String orderCode;

//    与orderCode二选一，三平台订单号,例如百度、饿了么、美团
    private String thirdOrderCode;

//    第三方售后单CODE
    private String thirdRefundCode;

//    下单渠道不能为空
    private Integer orderClient;

//    取消原因，当afterSalesType=用户取消的时候填写
    private String cancelReason;

//    申请金额，单位分，如果是全部退款，并且传递null,则自动填入 订单用户需支付金额"
    private Long reqAmount;

//    实际金额，单位分，如果是全部退款，并且传递null,则自动填入 订单用户需支付金额"
    private Long actualAmount;

//    传入的售后单类型为：2：售中用户取消 8：售后申请
    private Integer afterSalesType;

//    是否有退货货物
    private Boolean hasCargo;

//    商户自己生成的售后单单号
    private String partnerRefundCode;

//    用户填写的售后问题描述
    private String reqRemark;

//    用户填写的售后问题原因
    private String afterSalesReason ;

//    退货发生的原始运费-上门费
    private Long originalShippingFee ;

//    退货发生的结算运费-上门费结算
    private Long settlementShippingFee ;

//    配送渠道名称
    private String expressChannelName = "";

//    快递渠道编号
    private String expressChannelCode = "";

//    快递单号
    private String expressNo = "";

//    重量
    private Double weight ;

//    操作者
    private String operator = "";

//    扩展字段
    private String extInfo = "{}";

//    默认等于true，把所有剩余未申请售后的商品明细进行售后；若等于false，则必须填写afterSalesOrderItems
    private Boolean isAllItemAfterSales = true;

//    创建退货单之后需要执行的状态机事件,null则不执行，可选值 1-同意售后，状态变为【退货中】" +
//            "4-同意并退款完成，状态变为【完成】 5-同意并退货完成，状态变为【已退货】
    private Integer createEvent;

    private Integer timeOut;

//    @ApiModelProperty(value = "售后图片信息")
//    private List<AfterSalesImageReq> afterSalesImages = new ArrayList<>();

//    @ApiModelProperty(value = "退货商品明细")
//    private List<CreateAfterSalesOrderItemReq> afterSalesOrderItems = new ArrayList<>();

//    @ApiModelProperty(value = "地址信息")
//    private List<DeliveryContactInfoCreateReq> deliveryContactInfo = new ArrayList<>();

}
