package cn.freemud.management.adapter;

import cn.freemud.management.entities.dto.request.order.OrderManagerRequest;
import com.freemud.application.sdk.api.takeaway.request.order.BaseOrderRequest;
import com.freemud.application.sdk.api.takeaway.request.order.OrderSendOutRequest;
import com.freemud.application.sdk.api.takeaway.request.order.PlatformOrderRequest;
import com.freemud.sdk.api.assortment.order.response.order.QueryOrdersResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: WaimaiSdkAdapter
 * @Package cn.freemud.management.adapter
 * @Description:
 * @author: shuhu.hou
 * @date: 2020/4/20 14:38
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Component
public class WaimaiSdkAdapter {

    /**
     * 接单request
     * @param request
     * @param orderBean
     * @return
     */
    public PlatformOrderRequest getPlatformOrderRequest (OrderManagerRequest request, QueryOrdersResponse.DataBean.OrderBean orderBean){
        PlatformOrderRequest platformOrderRequest = new PlatformOrderRequest();
        platformOrderRequest.setPlatformOrderId(orderBean.getCustomerOrder());
        platformOrderRequest.setChannel(orderBean.getSource());
        platformOrderRequest.setCompanyId(orderBean.getCompanyId());
        platformOrderRequest.setOrderId(orderBean.getOid());
        platformOrderRequest.setShopId(orderBean.getShopId());
        platformOrderRequest.setOperator(request.getOperator());
        return platformOrderRequest;
    }

    /**
     * 配送request
     * @param request
     * @param orderBean
     * @return
     */
    public OrderSendOutRequest getOrderSendOutRequest (OrderManagerRequest request, QueryOrdersResponse.DataBean.OrderBean orderBean){
        OrderSendOutRequest orderSendOutRequest = new OrderSendOutRequest();
        orderSendOutRequest.setCompanyId(orderBean.getCompanyId());
        orderSendOutRequest.setOrderId(orderBean.getOid());
        orderSendOutRequest.setShopId(orderBean.getShopId());
        orderSendOutRequest.setOperator(request.getOperator());
        return orderSendOutRequest;
    }

    /**
     * 送达request
     * @param request
     * @param orderBean
     * @return
     */
    public OrderSendOutRequest getOrderArriveRequest (OrderManagerRequest request, QueryOrdersResponse.DataBean.OrderBean orderBean){
        OrderSendOutRequest arriveReq = new OrderSendOutRequest();
        arriveReq.setOrderId(orderBean.getOid());
        arriveReq.setChannel( orderBean.getSource());
        arriveReq.setCompanyId(orderBean.getCompanyId());
        arriveReq.setOperator(request.getOperator());
        arriveReq.setShopId(request.getStoreId());
        return arriveReq;
    }


}
