/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: GetProductVo
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: liming.guo
 * @date: 2018/5/16 17:35
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.vo;

import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

@Data
public class GetProductVo {

    /**
     * 菜单ID
     */
    private String menuId;
    /**
     * 菜单节点ID
     */
    private String nodeId;
    /**
     * 商户ID
     */
    private String partnerId;
    /**
     * 门店信息
     */
    private String shopId;
    /**
     * 点餐方式
     */
    private Integer orderType;
    /**
     * 页码，第一页为0，为空表示全部 ,默认升序
     */
    private Integer pageNo;
    /**
     * 页数，为空时表示全部
     */
    private Integer pageSize;

    @NotEmpty(message = "sessionId 不能为空")
    private String sessionId;

    private String version;

}
