package cn.freemud.entities.dto;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@NoArgsConstructor
public class OrderPrintDto {

    private String partnerId;
    private String storeId;
    /**
     * 日订单序号
     */
    private String daySeq;
    /**
     * 订单类型 1 外卖 2 预订单 3 商城 4 门店自提 5 堂食
     */
    private Integer type;
    /**
     * 订单Id
     */
    private String oid;
    /**
     * 用户名称
     */
    private String userName;
    /**
     * 用户手机号
     */
    private String phone;
    /**
     * 送货地址（自提，堂食为门店地址）
     */
    private String address;
    /**
     * 期望送达时间（可以是立即送出）
     */
    private String gmtExpect;
    /**
     * 配送方式描述（目前只是自配送）
     */
    private String deliveryTypeDesc;
    /**
     * 订单备注
     */
    private String remark;
    /**
     * 商品总数
     */
    private Integer productTotalAmount;
    /**
     * 商品总金额
     */
    private Long productAmount;
    /**
     * 餐盒费
     */
    private Long packageFee;
    /**
     * 配送费
     */
    private Long sendFee;
    /**
     * 优惠金额
     */
    private Long discountFee;
    /**
     * 用户支付金额
     */
    private Long userFee;
    /**
     * 下单时间
     */
    private String gmtCreate;
    /**
     * 门店名称
     */
    private String shopName;
    /**
     * 取餐号
     */
    private String otherCode;
    private List<ProductsBean> products;
    /**
     * 预约单，预约时间
     */
    private String expectTime;
    /**
     * 桌号
     */
    private String barCounter;

    @NoArgsConstructor
    @Data
    public static class ProductsBean {
        /**
         * productName : 珍珠奶茶
         * productOtherInfo : 常温  加奶盖 三分糖
         * number : 1
         * price : 1200
         */

        private String parentProductId;

        private Integer sequence;

        private String productId;
        /**
         * 商品名称
         */
        private String productName;
        /**
         * 商品规格加料信息
         */
        private String productOtherInfo;
        /**
         * 商品数量
         */
        private Integer number;
        /**
         * 商品价格
         */
        private Long price;
        //商品类型 6=套餐
        private Integer parentType;
        //套餐商品的子商品
        private List<ProductsBean> sonProducts;
    }

}
