package cn.freemud.amp.service;

import cn.freemud.amp.config.PushOrderConfig;
import cn.freemud.amqp.MQMessage;
import cn.freemud.amqp.MQService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * mq发送方
 */
@Service
public class ProduceMQService {
    @Autowired
    private MQService mqService;

    /**
     * 发送配送状态变更信息
     * @param body
     */
    public void sendOfDeliveryInfo(MQMessage body) {
        mqService.convertAndSend(PushOrderConfig.EXCHANGE_NAME, PushOrderConfig.OPEN_PLATFORM_ORDER_DELIVERY_ROUTING_KEY, body);
    }

}
