package com.freemud.sdk.api.assortment.shoppingcart.domain;

import lombok.Data;

import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: CartAddItem
 * @Package com.freemud.product.dto
 * @Description:
 * @author: ypf
 * @date: 2018/5/2 14:15
 * @Copyright: 2017 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目的
 */
@Data
public class CartAddItem {
    /**
     * 购物车item id
     */
    private String cartItemId;
    /**
     * id spuId
     */
    private String id;
    /**
     * 数量
     */
    private Integer qty;
    /**
     * 数量
     */
    private Integer isMaster;
    /**
     * 规格编号 skuId
     */
    private String specId;

    /**
     * 附加商品集
     */
    private List<CartExtra> addExtra;
    /**
     * 商品折扣信息
     */
    private DiscountMessage discountMessage;

    @Data
    public static class DiscountMessage {

        private String spuId;

        private String skuId;

        private String productName;
        /**
         * 活动id
         */
        private Long activityId;
        /**
         * 每单限购数量
         */
        private int limtBuyCountEachOrder;
        /**
         * 活动商品总库存
         */
        private long inventoryNumber;
        /**
         * 活动商品剩余库存
         */
        private Integer remainStock;
        /**
         * 折扣后的价格
         */
        private long discountPrice;
        /**
         * 原价
         */
        private long originPrice;
        /**
         * 享受折扣数量
         */
        private int discountQty;
    }

}