package com.freemud.sdk.api.aassortment.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.freemud.application.sdk.api.ordercenter.response.BaseResponse;
import com.freemud.application.sdk.api.ordercenter.response.orderInfo.CreateFatherSonOrderResp;
import com.freemud.sdk.api.aassortment.AssortmentOrderCenterApplication;
import com.freemud.sdk.api.assortment.order.enums.OrderSdkType;
import com.freemud.sdk.api.assortment.order.request.order.*;
import com.freemud.sdk.api.assortment.order.response.order.CreateOrderResponse;
import com.freemud.sdk.api.assortment.order.response.order.OrderDetailResponse;
import com.freemud.sdk.api.assortment.order.response.order.OrderDownloadResponse;
import com.freemud.sdk.api.assortment.order.response.order.QueryOrdersResponse;
import com.freemud.sdk.api.assortment.order.service.OrderCenterSdkService;
import com.google.gson.Gson;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import java.util.ArrayList;
import java.util.List;

@RunWith(SpringRunner.class)
@SpringBootTest(classes = AssortmentOrderCenterApplication.class)
public class OrderCenterSdkServiceTest {

    @Autowired
    private OrderCenterSdkService orderCenterSdkService;

    private static Gson gson = new Gson();

    @Test
    public void testCreateOrder() {
//        BaseCreateOrderRequest baseCreateOrderRequest = BaseCreateOrderRequest.builder()
//                .companyId("1864")
//                .shopId("1902281601")
//                .shopName("测试门店001")
//                .userId("115380294711781458")
//                .userName("tommy风")
//                .phone("15170070311")
//                .address("")
//                .longitude("")
//                .latitude("")
//                .orderType(QueryOrderType.COLLECT_GOODS)
//                .payType(QueryPayType.ONLINE_PAY)
//                .source("saas")
//                .sourceName("saas点餐")
//                .gmtExpect(null)
//                .amount(100L)
//                .build();
//        BaseCreateOrderRequest.DeliveryTypeInfo addInfo = new BaseCreateOrderRequest.DeliveryTypeInfo();
//        addInfo.setDeliveryType(QueryDeliveryType.SELF);
//        baseCreateOrderRequest.setAddInfo(addInfo);
//        List<CreateOrderProductRequest> products = new ArrayList<>();
//        CreateOrderProductRequest createOrderProductRequest = CreateOrderProductRequest.builder()
//                .productId("129253953761374982")
//                .productName("测试库存")
//                .number(1)
//                .specification("129920886306461488")
//                .specificationName("测试库存/16/大")
//                .customerCode("3234")
//                .price(1L)
//                .salePrice(1L)
//                .opid(1)
//                .addInfo(gson.toJson(OrderProductAddInfoRequest.builder().attributeNames("常温").build()))
//                .categoryId("0102")
//                .categoryName("功夫奶盖馆")
//                .discountList(Collections.emptyList())
//                .ignoreProductPrice(1).build();
//        products.add(createOrderProductRequest);
//        baseCreateOrderRequest.setProducts(products);
//        baseCreateOrderRequest.setAccounts(Collections.emptyList());
//        baseCreateOrderRequest.setOrderSdkType(OrderSdkType.OLD);
//        baseCreateOrderRequest.setTrackingNo("232223");
//        CreateOrderResponse createOrderResponse = orderCenterSdkService.createOrder(baseCreateOrderRequest);
//        System.out.println("createOrder_response=" + gson.toJson(createOrderResponse));
    }

    @Test
    public void getByIdForParentProduct() {
        BaseQueryOrderRequest request = new BaseQueryOrderRequest();
        request.setOrderId("129318938691699212");
        request.setTrackingNo("222");
        OrderDetailResponse response = orderCenterSdkService.getByIdForParentProduct(request);
        System.out.println(JSON.toJSONString(response));
    }

    @Test
    public void orderDownload() {
        OrderDownloadRequest request = new OrderDownloadRequest();
        request.setCompanyId("1864");
        request.setEndDate("2019-04-19");
        request.setPageNumber(1);
        request.setPageSize(1000);
        request.setStartDate("2019-04-13");
        request.setOrderType("1");
        request.setSource("saas");
        OrderDownloadResponse response = orderCenterSdkService.orderDownload(request);
        System.out.println(JSON.toJSONString(response));
    }

    @Test
    public void testQueryOrers() {
        String queryOrdersStr = "{\"userId\":\"115380294711781458\",\"companyId\":\"1864\",\"pageSize\":10,\"pageNumber\":1,\"startDate\":\"2019-03-21 00:00:00\",\"endDate\":\"2019-04-21 23:59:59\",\"status\":[1,3,4,31],\"source\":[\"saas\"],\"orderSdkType\":\"OLD\",\"trackingNo\":\"bf1e9d8cc4704b7fb4ede7c56adf3477\"}";
        QueryOrdersRequest queryOrdersRequest = gson.fromJson(queryOrdersStr, QueryOrdersRequest.class);
        QueryOrdersResponse queryOrdersResponse = orderCenterSdkService.queryOrders(queryOrdersRequest);
        System.out.println("queryOrders==" + gson.toJson(gson.toJson(queryOrdersResponse)));
    }

    @Test
    public void tesgetStatisticStoreOrderReport() {
        //{"companyId":"1864","endTime":1555920337547,"shopId":"1002","startTime":1555862400000,"source":["saas"],"statusList":[1,3,4,5,31]}
        GetStatisticStoreOrderReportRequest reportRequest = new GetStatisticStoreOrderReportRequest();

        reportRequest.setCompanyId("1864");
        reportRequest.setShopId("10086");
        reportRequest.setStartTime(1555862400000L);
        reportRequest.setEndTime(1555920337547L);
        String[] strings = {"saas"};
        reportRequest.setSource(strings);
        List<Integer> statusList = new ArrayList<>();
        statusList.add(1);
        statusList.add(3);
        statusList.add(4);
        statusList.add(5);
        statusList.add(31);
        reportRequest.setStatusList(statusList);
        orderCenterSdkService.getStatisticStoreOrderReport(reportRequest);
    }

    @Test
    public void getOrderListByConditionsTest() {
        List<String> orderIds = new ArrayList<>();
        orderIds.add("14446958671302323300005");
        QueryOrdersByConditionsRequest request = new QueryOrdersByConditionsRequest();
        request.setOrderIds(orderIds);
        request.setCompanyId("1864");
//        request.setStartTimestamp(1557741104L);
//        request.setEndTimestamp(1557827814L);
        request.setPageSize(0);
        QueryOrdersResponse orderListByConditions = orderCenterSdkService.getOrderListByConditions(request);
        System.out.println(JSON.toJSONString(orderListByConditions));
    }

    public static void main(String[] args) {
        String s = "{\n" +
                "  \"code\": \"100\",\n" +
                "  \"message\": \"成功\",\n" +
                "  \"result\": [\n" +
                "    {\n" +
                "      \"abnormalDesc\": \"\",\n" +
                "      \"abnormalState\": null,\n" +
                "      \"acceptTime\": null,\n" +
                "      \"actualArrivalTime\": null,\n" +
                "      \"actualPayAmount\": 1,\n" +
                "      \"afterSalesOrderList\": null,\n" +
                "      \"afterSalesState\": null,\n" +
                "      \"barCounter\": \"\",\n" +
                "      \"bizType\": 1,\n" +
                "      \"canRefund\": false,\n" +
                "      \"cancelReason\": \"\",\n" +
                "      \"companySelfCode\": \"\",\n" +
                "      \"createTime\": null,\n" +
                "      \"daySeq\": null,\n" +
                "      \"deliveryContactInfoList\": [\n" +
                "        {\n" +
                "          \"addressDetail\": \"南翔镇\",\n" +
                "          \"city\": \"\",\n" +
                "          \"contactsName\": \"初\",\n" +
                "          \"expressNo\": \"\",\n" +
                "          \"infoType\": 1,\n" +
                "          \"latitude\": null,\n" +
                "          \"longitude\": null,\n" +
                "          \"mobile\": \"18616552215\",\n" +
                "          \"province\": \"\",\n" +
                "          \"region\": \"\",\n" +
                "          \"relateObjectType\": 1,\n" +
                "          \"street\": \"\",\n" +
                "          \"telephone\": \"\",\n" +
                "          \"thirdDeliveryId\": \"\",\n" +
                "          \"tripDist\": null\n" +
                "        }\n" +
                "      ],\n" +
                "      \"deliveryPromise\": null,\n" +
                "      \"deliveryState\": null,\n" +
                "      \"deliveryTime\": null,\n" +
                "      \"dinersNumber\": null,\n" +
                "      \"dispenseStatus\": null,\n" +
                "      \"estimateDeliveryCompleteTime\": null,\n" +
                "      \"expectTime\": null,\n" +
                "      \"expressChannelCode\": \"\",\n" +
                "      \"expressChannelName\": \"\",\n" +
                "      \"expressNo\": \"\",\n" +
                "      \"expressType\": null,\n" +
                "      \"extInfo\": \"\",\n" +
                "      \"immediately\": false,\n" +
                "      \"isParent\": false,\n" +
                "      \"localTableKey\": \"\",\n" +
                "      \"marketingCode\": \"\",\n" +
                "      \"marketingType\": null,\n" +
                "      \"needInvoice\": false,\n" +
                "      \"note\": \"\",\n" +
                "      \"orderArea\": \"\",\n" +
                "      \"orderClient\": 2,\n" +
                "      \"orderCode\": \"14792003968781800000063\",\n" +
                "      \"orderCostDetailList\": [],\n" +
                "      \"orderInvoice\": null,\n" +
                "      \"orderItemList\": [\n" +
                "        {\n" +
                "          \"canRefund\": true,\n" +
                "          \"categoryId\": \"\",\n" +
                "          \"categoryName\": \"\",\n" +
                "          \"extInfo\": \"\",\n" +
                "          \"id\": 147920039701449490,\n" +
                "          \"ignoreInOrderClose\": false,\n" +
                "          \"marketingCode\": \"\",\n" +
                "          \"marketingType\": null,\n" +
                "          \"note\": \"\",\n" +
                "          \"parentProductId\": \"\",\n" +
                "          \"productCode\": \"\",\n" +
                "          \"productId\": \"141710339976881444\",\n" +
                "          \"productName\": \"西瓜汁\",\n" +
                "          \"productPicUrl\": \"https://picture.sandload.cn/1557903231067.png\",\n" +
                "          \"productPrice\": 1,\n" +
                "          \"productProperty\": \"\",\n" +
                "          \"productQuantity\": 1,\n" +
                "          \"productSeq\": 1,\n" +
                "          \"productSharePrice\": null,\n" +
                "          \"productSpec\": \"141710339976881444\",\n" +
                "          \"productSpecName\": \"西瓜汁\",\n" +
                "          \"productUnit\": \"\",\n" +
                "          \"productUpc\": \"\",\n" +
                "          \"productWeightUnit\": null,\n" +
                "          \"salePrice\": 1,\n" +
                "          \"settlementPrice\": null,\n" +
                "          \"thirdProductId\": \"\",\n" +
                "          \"weight\": null\n" +
                "        }\n" +
                "      ],\n" +
                "      \"orderOperationHistoryList\": null,\n" +
                "      \"orderSettlementDetailList\": [],\n" +
                "      \"orderState\": 1,\n" +
                "      \"orderSubState\": null,\n" +
                "      \"orderType\": 1,\n" +
                "      \"originalAmount\": 1,\n" +
                "      \"parentCode\": \"14792003965845786700068\",\n" +
                "      \"partnerId\": \"\",\n" +
                "      \"partnerName\": \"\",\n" +
                "      \"payChannel\": \"\",\n" +
                "      \"payChannelName\": \"\",\n" +
                "      \"payRequestNo\": \"\",\n" +
                "      \"payState\": null,\n" +
                "      \"payTime\": null,\n" +
                "      \"payType\": 1,\n" +
                "      \"pickUpGoodsNo\": \"\",\n" +
                "      \"pickUpTime\": null,\n" +
                "      \"posCode\": \"\",\n" +
                "      \"posTableKey\": \"\",\n" +
                "      \"printNum\": null,\n" +
                "      \"printTime\": null,\n" +
                "      \"receiveTime\": null,\n" +
                "      \"settlementAmount\": 1,\n" +
                "      \"storeId\": \"2019060403\",\n" +
                "      \"storeName\": \"0604门店伍平使用\",\n" +
                "      \"storeUnifyId\": \"\",\n" +
                "      \"suspendDesc\": \"\",\n" +
                "      \"suspendState\": null,\n" +
                "      \"thirdOrderCode\": \"14792003968781800000063\",\n" +
                "      \"toStoreId\": \"\",\n" +
                "      \"updateTime\": null,\n" +
                "      \"userId\": \"115523742853963763\",\n" +
                "      \"userName\": \"初\",\n" +
                "      \"weight\": null\n" +
                "    },\n" +
                "    {\n" +
                "      \"abnormalDesc\": \"\",\n" +
                "      \"abnormalState\": null,\n" +
                "      \"acceptTime\": null,\n" +
                "      \"actualArrivalTime\": null,\n" +
                "      \"actualPayAmount\": null,\n" +
                "      \"afterSalesOrderList\": null,\n" +
                "      \"afterSalesState\": null,\n" +
                "      \"barCounter\": \"\",\n" +
                "      \"bizType\": 2,\n" +
                "      \"canRefund\": false,\n" +
                "      \"cancelReason\": \"\",\n" +
                "      \"companySelfCode\": \"\",\n" +
                "      \"createTime\": null,\n" +
                "      \"daySeq\": null,\n" +
                "      \"deliveryContactInfoList\": [\n" +
                "        {\n" +
                "          \"addressDetail\": \"\",\n" +
                "          \"city\": \"\",\n" +
                "          \"contactsName\": \"\",\n" +
                "          \"expressNo\": \"\",\n" +
                "          \"infoType\": 1,\n" +
                "          \"latitude\": null,\n" +
                "          \"longitude\": null,\n" +
                "          \"mobile\": \"\",\n" +
                "          \"province\": \"\",\n" +
                "          \"region\": \"\",\n" +
                "          \"relateObjectType\": 1,\n" +
                "          \"street\": \"\",\n" +
                "          \"telephone\": \"\",\n" +
                "          \"thirdDeliveryId\": \"\",\n" +
                "          \"tripDist\": null\n" +
                "        }\n" +
                "      ],\n" +
                "      \"deliveryPromise\": null,\n" +
                "      \"deliveryState\": null,\n" +
                "      \"deliveryTime\": null,\n" +
                "      \"dinersNumber\": null,\n" +
                "      \"dispenseStatus\": null,\n" +
                "      \"estimateDeliveryCompleteTime\": null,\n" +
                "      \"expectTime\": null,\n" +
                "      \"expressChannelCode\": \"\",\n" +
                "      \"expressChannelName\": \"\",\n" +
                "      \"expressNo\": \"\",\n" +
                "      \"expressType\": null,\n" +
                "      \"extInfo\": \"\",\n" +
                "      \"immediately\": false,\n" +
                "      \"isParent\": false,\n" +
                "      \"localTableKey\": \"\",\n" +
                "      \"marketingCode\": \"\",\n" +
                "      \"marketingType\": null,\n" +
                "      \"needInvoice\": false,\n" +
                "      \"note\": \"\",\n" +
                "      \"orderArea\": \"\",\n" +
                "      \"orderClient\": 13,\n" +
                "      \"orderCode\": \"14792003972346959000091\",\n" +
                "      \"orderCostDetailList\": [],\n" +
                "      \"orderInvoice\": null,\n" +
                "      \"orderItemList\": [],\n" +
                "      \"orderOperationHistoryList\": null,\n" +
                "      \"orderSettlementDetailList\": [\n" +
                "        {\n" +
                "          \"agentDiscountAmount\": null,\n" +
                "          \"carrierDiscountAmount\": null,\n" +
                "          \"extInfo\": \"\",\n" +
                "          \"externalObjectId\": \"\",\n" +
                "          \"externalObjectName\": \"\",\n" +
                "          \"externalObjectSubId\": \"\",\n" +
                "          \"ignoreInDiscountAmount\": false,\n" +
                "          \"isOnline\": true,\n" +
                "          \"note\": \"会员卡原价\",\n" +
                "          \"number\": 1,\n" +
                "          \"platformDiscountAmount\": null,\n" +
                "          \"platformServiceAmount\": null,\n" +
                "          \"productId\": \"\",\n" +
                "          \"productSeq\": null,\n" +
                "          \"settlementAmount\": 2,\n" +
                "          \"settlementType\": 0,\n" +
                "          \"shopAmount\": null,\n" +
                "          \"shopDiscountAmount\": 2\n" +
                "        },\n" +
                "        {\n" +
                "          \"agentDiscountAmount\": null,\n" +
                "          \"carrierDiscountAmount\": null,\n" +
                "          \"extInfo\": \"\",\n" +
                "          \"externalObjectId\": \"\",\n" +
                "          \"externalObjectName\": \"\",\n" +
                "          \"externalObjectSubId\": \"\",\n" +
                "          \"ignoreInDiscountAmount\": false,\n" +
                "          \"isOnline\": true,\n" +
                "          \"note\": \"会员卡优惠金额\",\n" +
                "          \"number\": 1,\n" +
                "          \"platformDiscountAmount\": null,\n" +
                "          \"platformServiceAmount\": null,\n" +
                "          \"productId\": \"\",\n" +
                "          \"productSeq\": null,\n" +
                "          \"settlementAmount\": -1,\n" +
                "          \"settlementType\": 215,\n" +
                "          \"shopAmount\": null,\n" +
                "          \"shopDiscountAmount\": -1\n" +
                "        }\n" +
                "      ],\n" +
                "      \"orderState\": 1,\n" +
                "      \"orderSubState\": null,\n" +
                "      \"orderType\": 1,\n" +
                "      \"originalAmount\": 0,\n" +
                "      \"parentCode\": \"14792003965845786700068\",\n" +
                "      \"partnerId\": \"\",\n" +
                "      \"partnerName\": \"\",\n" +
                "      \"payChannel\": \"\",\n" +
                "      \"payChannelName\": \"\",\n" +
                "      \"payRequestNo\": \"\",\n" +
                "      \"payState\": null,\n" +
                "      \"payTime\": null,\n" +
                "      \"payType\": 1,\n" +
                "      \"pickUpGoodsNo\": \"\",\n" +
                "      \"pickUpTime\": null,\n" +
                "      \"posCode\": \"\",\n" +
                "      \"posTableKey\": \"\",\n" +
                "      \"printNum\": null,\n" +
                "      \"printTime\": null,\n" +
                "      \"receiveTime\": null,\n" +
                "      \"settlementAmount\": null,\n" +
                "      \"storeId\": \"2019060403\",\n" +
                "      \"storeName\": \"0604门店伍平使用\",\n" +
                "      \"storeUnifyId\": \"\",\n" +
                "      \"suspendDesc\": \"\",\n" +
                "      \"suspendState\": null,\n" +
                "      \"thirdOrderCode\": \"14792003972346959000091\",\n" +
                "      \"toStoreId\": \"\",\n" +
                "      \"updateTime\": null,\n" +
                "      \"userId\": \"13147920039723469591\",\n" +
                "      \"userName\": \"13147920039723469591\",\n" +
                "      \"weight\": null\n" +
                "    }\n" +
                "  ],\n" +
                "  \"ver\": \"1\"\n" +
                "}";
        BaseResponse<CreateFatherSonOrderResp> baseResponse = JSONObject.parseObject(s,new TypeReference<BaseResponse<CreateFatherSonOrderResp>>(){});
        System.out.println();
    }

    @Test
    public void testCreateGroupOrder(){
        AssortmentGroupCreateOrderRequest assortmentGroupCreateOrderRequest = new AssortmentGroupCreateOrderRequest();
        assortmentGroupCreateOrderRequest.setCompanyId("1864");
        assortmentGroupCreateOrderRequest.setShopId("0011");
        assortmentGroupCreateOrderRequest.setOrderClient(2);
        CreateOrderResponse createOrderResponse = orderCenterSdkService.createGroupOrder(assortmentGroupCreateOrderRequest);
        System.out.println("aaaa"+JSON.toJSONString(createOrderResponse));
    }

}
