package com.freemud.sdk.api.assortment.order.response.order;

import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.5.1
 * @Title: OrderDownloadResponseDto
 * @Package cn.freemud.entities.dto
 * @Description: 简单描述下这个类是做什么用的
 * @author: hang.chai
 * @date: 2018/12/18 16:04
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

@Data
public class OrderDownloadResponse {
    private Integer errcode;
    private String errmsg;

    /**
     * 2019-07-25 dingda.li
     * 调整为订单为行的数据类型
     */
    private List<OrderDownload> data;

    /**
     * 订单总条数
     */
    private Integer totalNum;

    @Data
    public static class OrderDownload{
        /**
         * 订单id
         */
        private String oid;
        /**
         * 门店名称
         */
        private String shopName;
        /**
         * 门店编号
         */
        private String shopId;
        /**
         * 顾客
         */
        private String userName;
        /**
         * 订单来源
         */
        private String source;
        /**
         * 手机号
         */
        private String phone;
        /**
         * 收获地址
         */
        private String address;
        /**
         * 订单类型type
         */
        private Integer type;
        /**
         * 订单类型描述
         */
        private String typeStr;
        /**
         * 订单状态type
         */
        private Integer status;
        /**
         * 订单状态描述
         */
        private String statusStr;
        /**
         * 订单总金额(分)
         */
        private Integer orderAmount;
        /**
         * 订单总金额(元)
         */
        private Double orderAmountYuan;
        /**
         * 订单实付金额(分)
         */
        private Integer amount;
        /**
         * 订单实付金额(元)
         */
        private Double amountYuan;
        /**
         * 菜品原价(分)
         */
        private Integer productAmount;
        /**
         * 菜品原价(元)
         */
        private Double productAmountYuan;
        /**
         * 餐盒费(分)
         */
        private Integer packageFee;
        /**
         * 餐盒费(元)
         */
        private Double packageFeeYuan;
        /**
         * 配送费(分)
         */
        private Integer deliveryFee;
        /**
         * 配送费(元)
         */
        private Double deliveryFeeYuan;
        /**
         * 活动支出(分)
         */
        private Integer acitviyCost;
        /**
         * 活动支出(元)
         */
        private Double acitviyCostYuan;
        /**
         * 活动内容
         */
        private String acivityItems;
        /**
         * 下单时间
         */
        private Date gmtCreate;
        /**
         * 支付时间
         */
        private Date gmtPay;
        /**
         * 商品编号
         */
        private String productId;
        /**
         * 商品名称
         */
        private String productName;
        /**
         * 商品数量
         */
        private String productNumber;
        /**
         * 商品价格(分)
         */
        private Integer productPrice;
        /**
         * 商品价格(元)
         */
        private Double productPriceYuan;
        /**
         * 商品优惠价格(即商品售价)
         */
        private Double productDiscountAmountYuan;
        //单个商品优惠总金额
        private BigDecimal productDiscountTotalPrice;
        /**
         * 设置为1标识1.5.2版本以后新订单，影响B端订单详情显示 1.5.2增加
         */
        private Integer ignoreProductPrice;
        /**
         * 非码交易号
         */
        private String payNo;
        /**
         * 支付状态
         */
        private String payStatus;
        /**
         * 外卖中台运单号
         */
        private String deliveryId;
        /**
         * 配送渠道（现在默认蜂鸟）
         */
        private String express;
        /**
         * 配送员姓名
         */
        private String riderName;
        /**
         * 配送员电话
         */
        private String riderPhone;
        /**
         * 三方订单编号
         */
        private String thirdOrderCode;
        /**
         * 门店渠道名称
         */
        private String organizationName;
    }
}
