package com.freemud.sdk.api.assortment.order.enums;

import org.apache.commons.lang.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

public enum PayEbCodeWXEnum {
    PAY_EB_CODE_WX_ENUM_10007("10007", "微信小程序支付10007"),
    PAY_EB_CODE_WX_ENUM_10087("10087", "微信小程序支付10087"),
    PAY_EB_CODE_WX_ENUM_10097("10097", "微信小程序支付10097"),
    PAY_EB_CODE_WX_ENUM_10101("10101", "微信小程序支付10101");
    private String code;
    private String message;

    PayEbCodeWXEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public static List<String> getAllCodes() {
        List<String> list = new ArrayList<String>();
        for (PayEbCodeWXEnum payEbCodeWXEnum : values()) {
            list.add(payEbCodeWXEnum.getCode());
        }
        return list;
    }

    public static String getCode(String code) {
        List<String> list = new ArrayList<String>();
        for (PayEbCodeWXEnum payEbCodeWXEnum : values()) {
            if (ObjectUtils.equals(code, payEbCodeWXEnum.getCode())) {
                return code;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return message;
    }

    public void setDesc(String desc) {
        this.message = message;
    }
}
