package cn.freemud.controller;


import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.vo.TakeMealNoticesVO;
import cn.freemud.service.CallerService;
import cn.freemud.utils.ResponseUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 叫号器
 */
@Slf4j
@RequestMapping("/caller")
@RestController
@Validated
public class CallerController {

private CallerService callerService;

    public CallerController(CallerService callerService) {
        this.callerService = callerService;
    }

    /**
     * 取餐通知
     * @return
     */
    public BaseResponse takeMealNotices(TakeMealNoticesVO vo){
        return  callerService.takeMealNotices(vo);
    }

}
