package cn.freemud.entities.dto.shoppingCart;

import cn.freemud.entities.dto.ActivityCalculationDiscountResponseDto;
import cn.freemud.entities.dto.OrderProductAddInfo;
import cn.freemud.entities.dto.activity.ActivityDiscountsDto;
import cn.freemud.entities.dto.activity.ShareDiscountActivityDto;
import cn.freemud.entities.vo.CartGoods;
import cn.freemud.entities.vo.MonthCardVo;
import cn.freemud.entities.vo.SubtractStockVO;
import com.alibaba.fastjson.JSON;
import lombok.Builder;
import lombok.Data;
import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;


@Data
public class ShoppingCartGoodsDto {

    /**
     * 购物车实际选择商品，包含加价购商品
     */
    private List<CartGoodsDetailDto> products;
    /**
     * 购物车版本号
     */
    private Integer carVer;
    /**
     * 用餐人数
     */
    private Integer peopleNumber;
    /**
     * 餐具总金额
     */
    private Integer mealPrice;

    /**
     * 餐具商品
     */
    List<CartGoodsDetailDto> dinnerProducts;


    /**
     * 购物车原总价
     */
    private Long originalTotalAmount;
    /**
     * 购物车现总价
     */
    private Long totalAmount;
    /**
     * 购物车总折扣价(优惠价)
     */
    private Long totalDiscountAmount;
    /**
     * 购物车总包装费
     */
    private Long packageAmount;
    /**
     * 积分扣减金额
     */
    private Long scoreReduceAmount;
    /**
     * 抵用积分
     */
    private Long reduceScore;

    /**
     * 请求计算的商品均摊信息
     */
    private List<ShareDiscountActivityDto> shareDiscountActivityDtos;

    /**
     * 第一次使用会员卡需多支付的金额 单位为分
     */
    private Integer memberCardAmount;

    /**
     * 会员卡原价
     */
    private Integer cardOriginalAmount;

    /**
     * 会员卡优惠金额
     */
    private Integer cardDiscountAmount;

    /**
     * 订单享受的促销活动
     */
    private List<ActivityDiscountsDto> activityDiscountsDtos;

    /**
     * 月享卡2.0优惠集合
     */
    private ActivityCalculationDiscountResponseDto.CalculationDiscountResult.MonthCardDiscount monthCardDiscount;

    /**
     * 扣减库存
     */
    private List<SubtractStockVO> stocks;

    /**
     * 配送费
     */
    private Long deliveryAmount;

    /**
     * 减免后配送费
     */
    private Long discountDeliveryAmount;

    /**
     * 满多少额度 减免
     */
    private Long thresholdAmount;

    /**
     * 是否参加满额减免
     */
    @Builder.Default
    private Boolean isDiscountDelivery = false;

    /**
     * 配送费活动号
     *
     */
    private String discountDeliveryActivityCode;
    /**
     * 满额减配送费描述
     */
    private String deliveryDiscountDesc;

    /**
     * 送集点
     */
    private SendPoint sendPoint;

    /**
     * 麦咖啡-咖啡月卡价格
     */
    private Long payCardFee;

    @Data
    public static class CartGoodsDetailDto {
        /**
         * 购物车行uid
         */
        private String cartGoodsUid;

        /**
         * 拼单买一赠一标记赠品是那个商品送的 originalGoodsUid
         */
        private String originalGoodsUid;

        /**
         * spuId
         */
        private String spuId;
        /**
         * spuId  如果是单品 skuId=spuId
         */
        private String skuId;
        /**
         * 商品的名称
         */
        private String spuName;
        private String spuForeignName;

        /**
         * 如果是单品 skuName=spuName
         */
        private String skuName;
        private String skuForeignName;
        /**
         * 商品行原始价格（单价）
         */
        private Long originalPrice;
        /**
         * 商品行售卖价格（单价）
         * 即促销价格，不包含订单级别优惠
         */
        private Long salePrice;
        /**
         * 商品图片
         */
        private String picture;

        /**
         * 购买人的的姓名
         */
        private String userName;

        /**
         * 购买人的的userId
         */
        private String userId;

        /**
         * 购买人的的openId
         */
        private String openId;

        /**
         * 购买人的的头像
         */
        private String photoUrl;

        /**
         * 购买人包装费
         */
        private Long packPrice;

        /**
         * 商品的数量
         */
        private Integer qty;
        /**
         * 商品行优惠总金额=数量*单个商品优惠金额
         */
        private Integer totalDiscountAmount;
        /**
         * 是否包含商品券
         */
        private Boolean hasProductCoupon = false;
        /**
         * 商品券code
         */
        private String couponCode;
        /**
         * 1.5.5版本添加
         * 商品参与活动类型(61:买一赠一)
         */
        private Integer activityType;

        /**
         * 1.6.0 版本增加  节点ID
         */
        private String nodeId;
        /**
         * 1.6.0 版本增加 分类名
         */
        private String categoryName;

        /**
         * 套餐--父级商品Id
         */
        private String parentProductId;

        /**
         * 套餐--type:6
         */
        private Integer productType;
        /**
         * 是否是套餐内固定商品
         */
        private Boolean isFixedProduct;
        private Long productGroupId;
        /**
         * 是否限制库存
         * 用于创建订单时，是否扣减库存
         */
        private boolean isStockLimit;
        /**
         * 是否餐具商品
         */
        private Integer isTableware = 0;
        /**
         * 是否是月享卡商品
         */
        private int isMonthCard;
        /**
         * 是否为种子券商品 1:是；0:否
         */
        private int isSeedCouponGoods;
        /**
         * 月享卡信息
         */
        private MonthCardVo monthCardInfo;
        /**
         * 商品货号
         */
        private String productCode;
        /**
         * 第三方商品编码
         */
        private String customerCode;
        /**
         * 重量
         */
        private Double weight;
        /**
         * 单位
         */
        private String unit;
        /**
         * 统计分类编号
         */
        private String classificationId;
        /**
         * 统计分类名称
         */
        private String classificationName;

        /**
         * 是否赠品
         */
        private Boolean isSendGoods;

        /**
         * 税率代码
         */
        private String taxId;

        /**
         * 税率
         */
        private Double tax;
        /**
         * 配料或属性
         */
        private List<CartGoodsDetailDto.CartGoodsExtra> extraList = new ArrayList<>(0);

        private List<CartGoods.SpecialExtra> specialExtra = new ArrayList<>();

        /**
         * 当前商品享受的促销活动
         */
        private List<ActivityDiscountsDto> activityDiscountsDtos;

        /**
         * 套餐子商品
         */
        private List<CartGoodsDetailDto> comboProducts;
        /**
         * 加料商品
         */
        private List<CartGoodsDetailDto.MaterialGoods> materialList = new ArrayList<>(0);

        @Data
        public final static class CartGoodsExtra {
            /**
             * 属性Id
             */
            private String attributeId;
            /**
             * 属性名
             */
            private String attributeName;
            private String attributeForeignName;
        }

        @Data
        public static class MaterialGoods {
            /**
             * 加料商品ID
             */
            private String spuId;
            private String spuName;
            private String spuForeignName;
            /**
             * 商品行记录：当前元售价
             */
            private Long originalPrice;
            /**
             * 商品行记录：当前售价
             */
            private Long salePrice;
            /**
             * 小料商品的数量
             */
            private Integer qty;
            /**
             * 商品行优惠总金额=数量*单个商品优惠金额
             */
            private Integer totalDiscountAmount;

            private String productCode;

            private String customerCode;
            /**
             * 当前商品享受的促销活动
             */
            private List<ActivityDiscountsDto> activityDiscountsDtos;
        }

        /**
         * 获取extras attributeNames
         */
        public String getAttributeNames() {
            String extras = "";
            String foreignExtras = "";
            if (CollectionUtils.isNotEmpty(this.extraList)) {
                extras = extraList.stream().map(CartGoodsDetailDto.CartGoodsExtra::getAttributeName).collect(Collectors.joining("/"));
                foreignExtras = extraList.stream().map(CartGoodsDetailDto.CartGoodsExtra::getAttributeForeignName).collect(Collectors.joining("/"));

            }
            return JSON.toJSONString(OrderProductAddInfo.builder().attributeNames(extras).attributeForeignNames(foreignExtras).build());
        }

    }

}
