package cn.freemud.service.thirdparty;

import cn.freemud.annotations.IgnoreFeignLogAnnotation;
import cn.freemud.constant.ResponseCodeConstant;
import cn.freemud.constant.ResponseCodeKeyConstant;
import cn.freemud.entities.dto.ProductBaseResponse;
import cn.freemud.entities.dto.RequiredProductRequest;
import cn.freemud.entities.dto.product.ValiadShopProductResponse;
import cn.freemud.entities.dto.product.ValidateShopProductRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: null.java
 * @Package
 * @Description: (用一句话描述该文件做什么)
 * @author: 蓝胖子(Hector)
 * @date: 2019-11-20
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目的
 */

@FeignClient(name = "PRODUCTSERVICE", url = "${saas.storeitemclient.feign.url}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface ProductClient {

    @PostMapping({"/Shop/ListMenuMustProduct"})
    @IgnoreFeignLogAnnotation(excludeStatusCodes = {ResponseCodeConstant.RESPONSE_SUCCESS_STR},statusCodeFieldName= ResponseCodeKeyConstant.ERR_CODE,messageFieldName = ResponseCodeKeyConstant.ERR_MSG)
    ProductBaseResponse<List<String>> getRequiredProductList(@RequestBody RequiredProductRequest request);


    @PostMapping({"/Shop/ValidateShopProduct/Reason"})
    @IgnoreFeignLogAnnotation(excludeStatusCodes = {ResponseCodeConstant.RESPONSE_SUCCESS_STR},statusCodeFieldName= ResponseCodeKeyConstant.ERR_CODE,messageFieldName = ResponseCodeKeyConstant.ERR_MSG)
    ProductBaseResponse<ValiadShopProductResponse> validateShopProductAboutReason(@RequestBody ValidateShopProductRequest request);

}
