/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: ShoppingCartAdapter
 * @Package cn.freemud.adapter
 * @Description:
 * @author: ping.wu
 * @date: 2018/5/26 17:42
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.adapter;

import cn.freemud.entities.dto.*;
import cn.freemud.entities.dto.activity.ActivityDiscountsDto;
import cn.freemud.entities.dto.openplatform.WeixinProductRequestDto;
import cn.freemud.entities.dto.shoppingCart.ShoppingCartGoodsDto;
import cn.freemud.entities.vo.*;
import cn.freemud.enums.ActivityTypeEnum;
import cn.freemud.enums.GoodsTypeEnum;
import cn.freemud.enums.ProductType;
import cn.freemud.utils.BeanUtil;
import com.freemud.application.sdk.api.productcenter.domain.ProductBeanDTO;
import com.freemud.sdk.api.assortment.shoppingcart.constant.CommonsConstant;
import com.google.common.collect.Lists;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.LongStream;

@Component
public class ShoppingCartConvertAdapter {

    public ShoppingCartGoodsDto.CartGoodsDetailDto getCartGoodsDetailDto(CreateOrderVo.PremiumExchangeActivity.Product product, GetProductsVo getProductsVo, String goodsId, ActivityCalculationDiscountResponseDto.CalculationDiscountResult.SendActivity.SendGoods sendGoods) {
        ShoppingCartGoodsDto.CartGoodsDetailDto cartGoodsDetailDto = new ShoppingCartGoodsDto.CartGoodsDetailDto();
        cartGoodsDetailDto.setOriginalPrice(getProductsVo.getFinalPrice());
        int totalDiscountAmount = product.getQty() * (getProductsVo.getFinalPrice().intValue() - sendGoods.getNowPrice().intValue());
        cartGoodsDetailDto.setTotalDiscountAmount(totalDiscountAmount);
        cartGoodsDetailDto.setSpuId(product.getSpuId());
        cartGoodsDetailDto.setSkuId(goodsId);
        cartGoodsDetailDto.setQty(product.getQty());
        cartGoodsDetailDto.setSpuName(getProductsVo != null ? getProductsVo.getSpuName() : "");
        cartGoodsDetailDto.setSkuName(product.getSkuName());
        cartGoodsDetailDto.setPicture(getProductsVo != null ? getProductsVo.getSpuPicture() : "");
        cartGoodsDetailDto.setActivityType(ActivityTypeEnum.TYPE_81.getCode());
        cartGoodsDetailDto.setClassificationId(getProductsVo.getCategory());
        cartGoodsDetailDto.setClassificationName(getProductsVo.getCategoryName());
        List<ShoppingCartGoodsDto.CartGoodsDetailDto.CartGoodsExtra> cartGoodsExtraList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(product.getAttributes())) {
            for (CreateOrderVo.PremiumExchangeActivity.Product.Attribute attribute : product.getAttributes()) {
                ShoppingCartGoodsDto.CartGoodsDetailDto.CartGoodsExtra cartGoodsExtra = new ShoppingCartGoodsDto.CartGoodsDetailDto.CartGoodsExtra();
                cartGoodsExtra.setAttributeId(attribute.getAttributeId());
                cartGoodsExtra.setAttributeName(attribute.getAttributeValue());
                cartGoodsExtraList.add(cartGoodsExtra);
            }
        }
        cartGoodsDetailDto.setExtraList(cartGoodsExtraList);
        return cartGoodsDetailDto;
    }

    /**
     * @param cartGoods
     * @return
     */
    public List<ShoppingCartGoodsDto.CartGoodsDetailDto> convertCartGoods2DetailGoodsList(CartGoods cartGoods, List<ActivityCalculationDiscountResponseDto.CalculationDiscountResult.ApportionGoods> apportionGoodsList, Map<String, String> duplicateGoodsMap) {
        List<ShoppingCartGoodsDto.CartGoodsDetailDto> cartGoodsDetailDtos = new ArrayList<>();
        if (GoodsTypeEnum.SET_MEAL_GOODS.getGoodsType().equals(cartGoods.getGoodsType())) {
            return cartGoodsDetailDtos;
        } else {
            cartGoodsDetailDtos.add(convertCartGoods2DetailGoods(cartGoods, apportionGoodsList, duplicateGoodsMap));
        }
        return cartGoodsDetailDtos;
    }

    /**
     * @param cartGoods
     * @return
     */
    public ShoppingCartGoodsDto.CartGoodsDetailDto convertCartGoods2DetailGoods(CartGoods cartGoods, List<ActivityCalculationDiscountResponseDto.CalculationDiscountResult.ApportionGoods> apportionGoodsList, Map<String, String> duplicateGoodsMap) {
        // 设置基础信息
        ShoppingCartGoodsDto.CartGoodsDetailDto cartGoodsDetailDto = new ShoppingCartGoodsDto.CartGoodsDetailDto();
        cartGoodsDetailDto.setCartGoodsUid(cartGoods.getCartGoodsUid());
        cartGoodsDetailDto.setTaxId(cartGoods.getTaxId());
        cartGoodsDetailDto.setTax(cartGoods.getTax());
        cartGoodsDetailDto.setSpuId(cartGoods.getSpuId());
        cartGoodsDetailDto.setSpuName(cartGoods.getSpuName());
        cartGoodsDetailDto.setSkuId(StringUtils.isEmpty(cartGoods.getSkuId()) ? cartGoods.getSpuId() : cartGoods.getSkuId());
        cartGoodsDetailDto.setSkuName(StringUtils.isEmpty(cartGoods.getSkuName()) ? cartGoods.getSpuName() : cartGoods.getSkuName());
        cartGoodsDetailDto.setOriginalPrice(cartGoods.getOriginalPrice());
        cartGoodsDetailDto.setTotalDiscountAmount(0);
        cartGoodsDetailDto.setSalePrice(cartGoods.getOriginalPrice());
        cartGoodsDetailDto.setPicture(cartGoods.getPic());
        cartGoodsDetailDto.setQty(cartGoods.getQty());
        cartGoodsDetailDto.setActivityType(cartGoods.getActivityType());
        cartGoodsDetailDto.setNodeId(cartGoods.getNodeId());
        cartGoodsDetailDto.setCategoryName(cartGoods.getCategoryName());
        cartGoodsDetailDto.setCouponCode(cartGoods.getCouponCode());
        cartGoodsDetailDto.setStockLimit(cartGoods.isStockLimit());
        cartGoodsDetailDto.setProductCode(cartGoods.getCustomerCode());
        cartGoodsDetailDto.setCustomerCode(cartGoods.getCustomerCode());
        cartGoodsDetailDto.setWeight(cartGoods.getWeight());
        cartGoodsDetailDto.setUnit(cartGoods.getUnit());
        cartGoodsDetailDto.setActivityDiscountsDtos(new ArrayList<>());
        cartGoodsDetailDto.setTotalDiscountAmount(0);
        cartGoodsDetailDto.setClassificationId(cartGoods.getClassificationId());
        cartGoodsDetailDto.setClassificationName(cartGoods.getClassificationName());
        if (GoodsTypeEnum.SET_MEAL_GOODS.getGoodsType().equals(cartGoods.getGoodsType())) {
            cartGoodsDetailDto.setProductType(ProductType.SETMEAL.getCode());
        } else if (cartGoods.isWeightType()) {
            cartGoodsDetailDto.setProductType(ProductType.WEIGHT_PRODUCT.getCode());
        }
        //小料
        if (CollectionUtils.isNotEmpty(cartGoods.getProductMaterialList())) {
            List<ShoppingCartGoodsDto.CartGoodsDetailDto.MaterialGoods> materialList = new ArrayList<>(0);
            for (CartGoods.MaterialGoods materialGoods : cartGoods.getProductMaterialList()) {
                ShoppingCartGoodsDto.CartGoodsDetailDto.MaterialGoods goods = new ShoppingCartGoodsDto.CartGoodsDetailDto.MaterialGoods();
                goods.setSpuId(materialGoods.getSpuId());
                goods.setSpuName(materialGoods.getSpuName());
                goods.setOriginalPrice(materialGoods.getOriginalPrice());
                goods.setSalePrice(materialGoods.getFinalPrice());
                goods.setQty(cartGoods.getQty());
                goods.setTotalDiscountAmount(0);
                materialList.add(goods);
            }
            cartGoodsDetailDto.setMaterialList(materialList);
        }
        // 设置总优惠&售价
        List<ShoppingCartGoodsDto.CartGoodsDetailDto.CartGoodsExtra> cartGoodsExtras = BeanUtil.convertBeans(cartGoods.getExtra(), ShoppingCartGoodsDto.CartGoodsDetailDto.CartGoodsExtra::new);
        cartGoodsDetailDto.setExtraList(cartGoodsExtras);
        //61: 单品买M赠N  \  62:买赠  \ 6:买M赠N
        if (ObjectUtils.equals(ActivityTypeEnum.TYPE_61.getCode(), cartGoods.getActivityType()) || ObjectUtils.equals(ActivityTypeEnum.TYPE_6.getCode(), cartGoods.getActivityType())
                || ObjectUtils.equals(ActivityTypeEnum.TYPE_62.getCode(), cartGoods.getActivityType())) {
            cartGoodsDetailDto.setTotalDiscountAmount(cartGoods.getOriginalAmount().intValue() - cartGoods.getAmount().intValue());
        } else {
            List<ActivityCalculationDiscountResponseDto.CalculationDiscountResult.ApportionGoods> collect = apportionGoodsList.stream().filter(a -> ObjectUtils.equals(cartGoods.getCartGoodsUid(), a.getCartGoodsUid())).collect(Collectors.toList());
            //List<ActivityCalculationDiscountResponseDto.CalculationDiscountResult.ApportionGoods> collect = apportionGoodsList.stream().filter(a -> ObjectUtils.equals(cartGoods.getSkuId(), a.getGoodsId()) || ObjectUtils.equals(cartGoods.getSpuId(), a.getGoodsId())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(collect)) {
                setTotalDiscountAndSalePrice(collect, cartGoodsDetailDto, duplicateGoodsMap);
                // 设置商品行，优惠活动均摊
                setActivityDiscounts(collect, cartGoodsDetailDto, duplicateGoodsMap);
            }
        }
        return cartGoodsDetailDto;
    }

    private void setActivityDiscounts(List<ActivityCalculationDiscountResponseDto.CalculationDiscountResult.ApportionGoods> apportionGoodsList, ShoppingCartGoodsDto.CartGoodsDetailDto cartGoodsDetailDto, Map<String, String> duplicateGoodsMap) {
        List<ActivityDiscountsDto> activityDiscountsDtoList = new ArrayList<>();
        int goodsTotalQty = apportionGoodsList.stream().mapToInt(apportionGoods -> apportionGoods.getGoodsQuantity()).sum();
        for (ActivityCalculationDiscountResponseDto.CalculationDiscountResult.ApportionGoods apportionGoods : apportionGoodsList) {
            /**
             * 1. 商品券：cartGoodsDetailDto.couponCode非空，保留ApportionGoods#ApportionDetails#apportionType中32的
             * 2. 普通商品：cartGoodsDetailDto.couponCode空，去掉32的
             */
            List<ActivityCalculationDiscountResponseDto.CalculationDiscountResult.ApportionGoods.ApportionDetails> apportionDetails = apportionGoods.getApportionDetails().stream().filter(detail -> !detail.getActivityType().equals(ActivityTypeEnum.TYPE_32.getCode())
                    && !detail.getActivityType().equals(ActivityTypeEnum.TYPE_104.getCode()) && !detail.getActivityType().equals(ActivityTypeEnum.TYPE_2.getCode()) && !detail.getActivityType().equals(ActivityTypeEnum.TYPE_21.getCode())).collect(Collectors.toList());
            for (ActivityCalculationDiscountResponseDto.CalculationDiscountResult.ApportionGoods.ApportionDetails detail : apportionDetails) {
                List<ActivityDiscountsDto> currentDiscount = activityDiscountsDtoList.stream().filter(discount -> ObjectUtils.equals(discount.getActivityCode(), detail.getActivityCode())).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(currentDiscount)) {
                    currentDiscount.get(0).setDiscountAmount(currentDiscount.get(0).getDiscountAmount() + detail.getActivityApportionAmount().intValue() * apportionGoods.getGoodsQuantity() * cartGoodsDetailDto.getQty() / goodsTotalQty);
                } else {
                    ActivityDiscountsDto activityDiscountsDto = new ActivityDiscountsDto();
                    activityDiscountsDto.setActivityCode(detail.getActivityCode());
                    activityDiscountsDto.setActivityName(detail.getActivityName());
                    activityDiscountsDto.setActivityType(detail.getActivityType());
                    activityDiscountsDto.setDiscountAmount(detail.getActivityApportionAmount().intValue() * apportionGoods.getGoodsQuantity() * cartGoodsDetailDto.getQty() / goodsTotalQty);
                    activityDiscountsDtoList.add(activityDiscountsDto);
                }
            }
        }
        cartGoodsDetailDto.setActivityDiscountsDtos(activityDiscountsDtoList);
    }

    /**
     *  活动级别的促销均摊
     * 获取当前商品的售后价格
     *
     * @param apportionGoodsList 促销均摊列表
     * @param cartGoodsDetailDto 当前商品行
     * @param duplicateGoodsMap 当前商品行  此map是为了促销除不尽时，拆商品行所用，例如，3份折扣10元
     * key为：goodsId；value以逗号分割：0为goodsId分组对应的数量，value为已计算的折扣金额
     *
     */
    private void setTotalDiscountAndSalePrice(List<ActivityCalculationDiscountResponseDto.CalculationDiscountResult.ApportionGoods> apportionGoodsList, ShoppingCartGoodsDto.CartGoodsDetailDto cartGoodsDetailDto, Map<String, String> duplicateGoodsMap) {
        Long originalPrice = cartGoodsDetailDto.getOriginalPrice();
        Long discountPrice = 0L;
        int goodsTotalQty = apportionGoodsList.stream().mapToInt(apportionGoods -> apportionGoods.getGoodsQuantity()).sum();
        for (ActivityCalculationDiscountResponseDto.CalculationDiscountResult.ApportionGoods apportionGoods : apportionGoodsList) {
            //折扣=所有折扣和*百分比（当前行商品数量/购物车总商品数量）
            discountPrice += apportionGoods.getApportionDetails().stream().filter(d -> ObjectUtils.notEqual(ActivityTypeEnum.TYPE_32.getCode(), d.getActivityType())
                    && ObjectUtils.notEqual(ActivityTypeEnum.TYPE_104.getCode(), d.getActivityType()) //X件Y折
                    && ObjectUtils.notEqual(ActivityTypeEnum.TYPE_2.getCode(), d.getActivityType()) //单品特价
                    && ObjectUtils.notEqual(ActivityTypeEnum.TYPE_21.getCode(), d.getActivityType())//单品折扣
            ).mapToLong(t -> t.getActivityApportionAmount() * apportionGoods.getGoodsQuantity()).sum() * cartGoodsDetailDto.getQty() / goodsTotalQty;
        }
        String currentGoodsIdMap = duplicateGoodsMap.get(cartGoodsDetailDto.getCartGoodsUid());
        if (currentGoodsIdMap != null) {
            String[] value = currentGoodsIdMap.split(",");
            //不是最后一行商品，折扣为discountPrice
            if (Integer.parseInt(value[0]) > 1) {
                int totalDiscountPrice = Integer.parseInt(value[1]) + discountPrice.intValue();
                int index = Integer.parseInt(value[0]) - 1;
                duplicateGoodsMap.put(cartGoodsDetailDto.getCartGoodsUid(), String.format("%s,%s", index, totalDiscountPrice));
            } else {
                //最后一行
                Long totalDiscountAmount = 0L;
                for (ActivityCalculationDiscountResponseDto.CalculationDiscountResult.ApportionGoods apportionGoods : apportionGoodsList) {
                    totalDiscountAmount += apportionGoods.getApportionDetails().stream().filter(d -> ObjectUtils.notEqual(ActivityTypeEnum.TYPE_32.getCode(), d.getActivityType())
                            && ObjectUtils.notEqual(ActivityTypeEnum.TYPE_104.getCode(), d.getActivityType())
                            && ObjectUtils.notEqual(ActivityTypeEnum.TYPE_2.getCode(), d.getActivityType())
                            && ObjectUtils.notEqual(ActivityTypeEnum.TYPE_21.getCode(), d.getActivityType())
                    ).mapToLong(t -> t.getActivityApportionAmount() * apportionGoods.getGoodsQuantity()).sum();
                }
                //折扣为：总折扣金额-已折扣金额
                discountPrice = totalDiscountAmount - Integer.parseInt(value[1]);
            }
        }
        cartGoodsDetailDto.setTotalDiscountAmount(discountPrice.intValue());
        cartGoodsDetailDto.setSalePrice(originalPrice - discountPrice / cartGoodsDetailDto.getQty());
    }

    /**
     * @param cartGoods
     * @return
     */
    public List<ShoppingCartGoodsDto.CartGoodsDetailDto> convertComboxGoods2DetailGoods(CartGoods cartGoods,Integer totalDiscountAmount) {
        List<ShoppingCartGoodsDto.CartGoodsDetailDto> cartGoodsDetailDtos = new ArrayList<>();
        cartGoodsDetailDtos.addAll(getComboxGoods2DetailGoods(cartGoods, cartGoods.getProductComboList(), true,totalDiscountAmount));
        cartGoodsDetailDtos.addAll(getComboxGoods2DetailGoods(cartGoods, cartGoods.getProductGroupList(), false,totalDiscountAmount));
        return cartGoodsDetailDtos;
    }


    /**
     * @param cartGoods
     * @return
     */
    public List<ShoppingCartGoodsDto.CartGoodsDetailDto> getComboxGoods2DetailGoods(CartGoods cartGoods, List<CartGoods.ComboxGoods> comboxGoodsList, boolean isFixed,Integer totalDiscountAmount) {
        List<ShoppingCartGoodsDto.CartGoodsDetailDto> cartGoodsDetailDtos = new ArrayList<>();
        if (CollectionUtils.isEmpty(comboxGoodsList)) {
            return cartGoodsDetailDtos;
        }
        int size = comboxGoodsList.size();
        //当前套餐(固定搭配)总优惠=原总价-现总价-可选商品优惠价
        Long discountAmount = totalDiscountAmount -
                cartGoods.getProductGroupList().stream().mapToLong(product -> (product.getOriginalPrice() - product.getFinalPrice()) * product.getQty()).sum() * cartGoods.getQty();
        // 当前套餐（固定搭配）总原价
        Long totalOriginalPrice = cartGoods.getProductComboList().stream().mapToLong(cart -> cart.getQty() * cart.getOriginalPrice()).sum() * cartGoods.getQty();
        Integer tempDiscount = 0;
        for (CartGoods.ComboxGoods comboxGoods : comboxGoodsList) {
            ShoppingCartGoodsDto.CartGoodsDetailDto cartGoodsDetailDto = new ShoppingCartGoodsDto.CartGoodsDetailDto();
            cartGoodsDetailDto.setTaxId(cartGoods.getTaxId());
            cartGoodsDetailDto.setTax(cartGoods.getTax());
            cartGoodsDetailDto.setSpuId(comboxGoods.getGoodsId());
            cartGoodsDetailDto.setSpuName(comboxGoods.getSpuName());
            cartGoodsDetailDto.setSkuId(comboxGoods.getGoodsId());
            cartGoodsDetailDto.setSkuName(StringUtils.isEmpty(comboxGoods.getSkuName()) ? comboxGoods.getSpuName() : comboxGoods.getSkuName());
            cartGoodsDetailDto.setOriginalPrice(comboxGoods.getOriginalPrice());
            cartGoodsDetailDto.setPicture(comboxGoods.getPic());
            int qty = comboxGoods.getQty() * cartGoods.getQty();
            cartGoodsDetailDto.setQty(qty);
            cartGoodsDetailDto.setProductType(comboxGoods.isWeightType() ? ProductType.WEIGHT_PRODUCT.getCode() : ProductType.SETMEAL.getCode());
            cartGoodsDetailDto.setParentProductId(cartGoods.getGoodsId());
            cartGoodsDetailDto.setIsFixedProduct(isFixed);
            cartGoodsDetailDto.setStockLimit(cartGoods.isStockLimit());
            cartGoodsDetailDto.setCustomerCode(comboxGoods.getCustomerCode());
            cartGoodsDetailDto.setWeight(comboxGoods.getWeight());
            cartGoodsDetailDto.setUnit(comboxGoods.getUnit());
            List<ShoppingCartGoodsDto.CartGoodsDetailDto.CartGoodsExtra> cartGoodsExtras = BeanUtil.convertBeans(comboxGoods.getExtra(), ShoppingCartGoodsDto.CartGoodsDetailDto.CartGoodsExtra::new);
            cartGoodsDetailDto.setExtraList(cartGoodsExtras);
            //获取当前套餐固定商品的均摊价格
            if (isFixed) {
                if (size-- == 1) {
                    cartGoodsDetailDto.setTotalDiscountAmount(discountAmount.intValue() - tempDiscount);
                } else {
                    Long currentDiscountAmount = (qty * comboxGoods.getOriginalPrice() * discountAmount) / totalOriginalPrice;
                    cartGoodsDetailDto.setTotalDiscountAmount(currentDiscountAmount.intValue());
                    tempDiscount += currentDiscountAmount.intValue();
                }
            } else {
                cartGoodsDetailDto.setTotalDiscountAmount((comboxGoods.getOriginalPrice().intValue() - comboxGoods.getFinalPrice().intValue()) * comboxGoods.getQty() * cartGoods.getQty());
            }
            cartGoodsDetailDtos.add(cartGoodsDetailDto);
        }
        return cartGoodsDetailDtos;
    }


    public WeixinProductRequestDto convent2WeixinProductRequestDto(AddGoodsByWeixinCardRequestVo request) {
        WeixinProductRequestDto requestDto = new WeixinProductRequestDto();
        requestDto.setPartnerId(request.getPartnerId());
        requestDto.setCardId(request.getCardId());
        requestDto.setAppId(request.getAppId());
        requestDto.setEncryptCode(request.getEncryptCode());
        return requestDto;
    }

    public AddShoppingCartGoodsRequestVo convent2AddshoppingCartGoods(AddGoodsByWeixinCardRequestVo request, GetProductsVo getProductsVo) {
        AddShoppingCartGoodsRequestVo cartGoodsRequestVo = new AddShoppingCartGoodsRequestVo();
        cartGoodsRequestVo.setSessionId(request.getSessionId());
        cartGoodsRequestVo.setPartnerId(request.getPartnerId());
        cartGoodsRequestVo.setShopId(request.getShopId());
        cartGoodsRequestVo.setAppId(request.getAppId());
        cartGoodsRequestVo.setSpuId(request.getEncryptCode());
        // cartGoodsRequestVo.setSkuId(getProductsVo.getSkuId());
        List<GetMenuResponseDto.DataBean.RootNodeBean.ChildrenBeanFirst.ChildrenBeanSecond.ProductBean.ProductAttributeGroupListBean> productAttributeGroupList = getProductsVo.getProductAttributeGroupList();
        if (productAttributeGroupList != null && productAttributeGroupList.size() > 0) {
            List<CartGoods.CartGoodsExtra> cartGoodsExtraList = new ArrayList<>();
            for (GetMenuResponseDto.DataBean.RootNodeBean.ChildrenBeanFirst.ChildrenBeanSecond.ProductBean.ProductAttributeGroupListBean productAttributeList : productAttributeGroupList) {
                CartGoods.CartGoodsExtra goodsExtra = new CartGoods.CartGoodsExtra();
                goodsExtra.setAttributeId(productAttributeList.getAttributeValues().get(0).getAttributeId());
                goodsExtra.setAttributeName(productAttributeList.getAttributeValues().get(0).getAttributeValue());
                cartGoodsExtraList.add(goodsExtra);
            }
            cartGoodsRequestVo.setExtra(cartGoodsExtraList);
        }
        return cartGoodsRequestVo;
    }

    public CartGoods convent2CartGoods(CartGoods cartGood, Long nowPirce) {
        CartGoods cartGoods = new CartGoods();
        cartGoods.setCartGoodsUid(cartGood.getCartGoodsUid());
        cartGoods.setGoodsId(cartGood.getGoodsId());
        cartGoods.setGoodsType(cartGood.getGoodsType());
        cartGoods.setSpuId(cartGood.getSpuId());
        cartGoods.setSkuId(cartGood.getSkuId());
        cartGoods.setSpecProductId(cartGood.getSpecProductId());
        cartGoods.setOriginalPrice(nowPirce);
        cartGoods.setPackPrice(cartGood.getPackPrice());
        cartGoods.setOriginalAmount(nowPirce);
        cartGoods.setAmount(0L);
        cartGoods.setName(cartGood.getName());
        cartGoods.setSpuName(cartGood.getSpuName());
        cartGoods.setSubName(cartGood.getSubName());
        cartGoods.setNodeId(cartGood.getNodeId());
        cartGoods.setCategoryName(cartGood.getCategoryName());
        List<CartGoods.CartGoodsExtra> extra = Lists.newArrayList();
        List<CartGoods.CartGoodsExtra> cartGoodsExtras = cartGood.getExtra();
        if (CollectionUtils.isNotEmpty(cartGoodsExtras)) {
            cartGoodsExtras.forEach(cartGoodsExtra -> {
                CartGoods.CartGoodsExtra goodsExtra = new CartGoods.CartGoodsExtra();
                goodsExtra.setAttributeId(cartGoodsExtra.getAttributeId());
                goodsExtra.setAttributeName(cartGoodsExtra.getAttributeName());
                extra.add(goodsExtra);
            });
        }
        cartGoods.setExtra(extra);
        cartGoods.setPic(cartGood.getPic());
        cartGoods.setCreateTimeMili(cartGood.getCreateTimeMili());
        cartGoods.setSkuName(cartGood.getSkuName());
        cartGoods.setSkuName(cartGood.getSkuName());
        cartGood.setClassificationId(cartGood.getClassificationId());
        cartGood.setClassificationName(cartGood.getClassificationName());
        cartGoods.setActivityType(ActivityTypeEnum.TYPE_61.getCode());
        return cartGoods;
    }

    public static CartGoods convent2CartGoods(AddShoppingCartGoodsRequestVo addShoppingCartGoodsRequestVo) {
        String spuId = addShoppingCartGoodsRequestVo.getSpuId();
        String skuId = addShoppingCartGoodsRequestVo.getSkuId();
        String goodsId = StringUtils.isEmpty(skuId) ? spuId : skuId;
        Integer qty = addShoppingCartGoodsRequestVo.getQty() == null ? 1 : addShoppingCartGoodsRequestVo.getQty();
        CartGoods cartGoods = new CartGoods();
        cartGoods.setGoodsId(goodsId);
        cartGoods.setSpuId(spuId);
        cartGoods.setSkuId(skuId);
        cartGoods.setQty(qty);
        cartGoods.setCouponCode(addShoppingCartGoodsRequestVo.getCouponCode());
        Integer goodsType = StringUtils.isEmpty(skuId)||ObjectUtils.equals(spuId,skuId) ? GoodsTypeEnum.SPU_GOODS.getGoodsType() : GoodsTypeEnum.SKU_GOODS.getGoodsType();
        if (spuId.startsWith(CommonsConstant.COUPON_PREFIX)) {
            goodsType = GoodsTypeEnum.COUPON_GOODS.getGoodsType();
        } else if (CollectionUtils.isNotEmpty(addShoppingCartGoodsRequestVo.getProductComboList()) || CollectionUtils.isNotEmpty(addShoppingCartGoodsRequestVo.getProductGroupList())) {
            goodsType = GoodsTypeEnum.SET_MEAL_GOODS.getGoodsType();
        }
        cartGoods.setGoodsType(goodsType);
        cartGoods.setExtra(addShoppingCartGoodsRequestVo.getExtra());
        cartGoods.setNodeId(addShoppingCartGoodsRequestVo.getNodeId());
        cartGoods.setCategoryName(addShoppingCartGoodsRequestVo.getCategoryName());
        List<CartGoods.ComboxGoods> productComboList = new ArrayList<>();
        List<CartGoods.ComboxGoods> productGroupList = new ArrayList<>();
        List<CartGoods.MaterialGoods> materialGoodsList = new ArrayList<>();
        //套餐
        if (CollectionUtils.isNotEmpty(addShoppingCartGoodsRequestVo.getProductComboList())) {
            for (ComboxGoodsRequestVo vo : addShoppingCartGoodsRequestVo.getProductComboList()) {
                CartGoods.ComboxGoods productCombox = new CartGoods.ComboxGoods();
                productCombox.setGoodsId(vo.getSkuId());
                productCombox.setSkuId(vo.getSkuId());
                productCombox.setQty(vo.getQty());
                productCombox.setExtra(vo.getExtra());
                productComboList.add(productCombox);
            }
        }
        //固定商品组
        if (CollectionUtils.isNotEmpty(addShoppingCartGoodsRequestVo.getProductGroupList())) {
            for (ComboxGoodsRequestVo vo : addShoppingCartGoodsRequestVo.getProductGroupList()) {
                CartGoods.ComboxGoods productCombox = new CartGoods.ComboxGoods();
                productCombox.setGoodsId(vo.getSkuId());
                productCombox.setSkuId(vo.getSkuId());
                productCombox.setQty(vo.getQty());
                productCombox.setExtra(vo.getExtra());
                productCombox.setProductGroupId(StringUtils.isEmpty(vo.getProductGroupId()) ? null : Long.parseLong(vo.getProductGroupId()));
                productGroupList.add(productCombox);
            }
        }
        //加料商品集
        if (CollectionUtils.isNotEmpty(addShoppingCartGoodsRequestVo.getProductMaterialList())) {
            for (MaterialRequestVo materialRequestVo : addShoppingCartGoodsRequestVo.getProductMaterialList()) {
                CartGoods.MaterialGoods materialGoods = new CartGoods.MaterialGoods();
                materialGoods.setSpuId(materialRequestVo.getSpuId());
                materialGoodsList.add(materialGoods);
            }
        }
        cartGoods.setProductComboList(productComboList);
        cartGoods.setProductGroupList(productGroupList);
        cartGoods.setProductMaterialList(materialGoodsList);
        return cartGoods;
    }

    /**
     * 设置统计分类编码和统计分类名称
     *
     * @param cartGoods
     * @param productBeanListSpuClass
     */
    public static void setClassification(CartGoods cartGoods, List<ProductBeanDTO> productBeanListSpuClass) {
        cartGoods.setClassificationId(productBeanListSpuClass.get(0).getCategory());
        cartGoods.setClassificationName(productBeanListSpuClass.get(0).getCategoryName());
    }

    /**
     * 设置统计分类编码和统计分类名称
     *
     * @param cartGoods
     * @param getProductsVo
     */
    public static void setClassification(CartGoods cartGoods, GetProductsVo getProductsVo) {
        cartGoods.setClassificationId(getProductsVo.getCategory());
        cartGoods.setClassificationName(getProductsVo.getCategoryName());
    }

    /**
     * 兼容 skuId 不传转null 导致库存校验 NullPointerException
     *
     * @param addShoppingCartGoodsRequestVo
     */
    public static void convent2SkuId(AddShoppingCartGoodsRequestVo addShoppingCartGoodsRequestVo) {
        String skuId = StringUtils.isNotBlank(addShoppingCartGoodsRequestVo.getSkuId()) ? addShoppingCartGoodsRequestVo.getSkuId() : "";
        addShoppingCartGoodsRequestVo.setSkuId(skuId);
    }

    public String jointPk(String a, String b) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.append(a).append(b).toString();
    }
}