package cn.freemud.demo.entities.bo;

import cn.freemud.demo.entities.bo.goods.DiscountResultBO;
import cn.freemud.demo.entities.bo.goods.ManagerServiceBO;
import cn.freemud.demo.entities.bo.goods.ShoppingCartGoodsApportionBO;
import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

import java.util.List;

@Data
public class GetCalCostBO {

    /**
     * 收货地址ID、svc卡支付外卖订单必传
     */
    private String receiveId;
    private String partnerId;

    private String shopId;
    private String userId;
    /**
     * 微信appId
     */
    @NotEmpty(message = "appId不能为空")
    private String appId;
    /**
     * 下单类型 CreateOrderType 外卖、到店、商城
     */
    private Integer orderType;
    private ManagerServiceBO managerService;
    /**
     * 优惠券号
     */
    private String couponCode;
    /**
     * 优惠券code列表
     */
    private List<CouponCode> couponCodes;
    /**
     * 活动号
     */
    private String activityCode;
    /**
     * 加价购商品
     */
    private List<SendGoods> sendGoods;

    private DiscountResultBO discountResultBO;


}
