package cn.freemud.entities.dto.product.pointsmall;

import lombok.Data;

import java.util.List;

@Data
public class IntegralProductType {

//    @ApiModelProperty(value = "商品编号")
    private String productId;

//    @ApiModelProperty(value = "商品名称")
    private String productName;

//    @ApiModelProperty(value = "商品类型（1优惠券，2实物）")
    private Integer productType;

//    @ApiModelProperty(value = "图片列表")
    private List<String> pictureList;

//    @ApiModelProperty(value = "优惠券编号")
    private String couponCode;

//    @ApiModelProperty(value = "兑换方式（1积分，2现金，3积分+现金）")
    private Integer exchangeType;

//    @ApiModelProperty(value = "积分价格")
    private Integer integralPrice;

//    @ApiModelProperty(value = "现金价格（分）")
    private Integer cashPrice;

//    @ApiModelProperty(value = "分类编号")
    private String categoryId;

//    @ApiModelProperty(value = "分类名称")
    private String categoryName;

//    @ApiModelProperty(value = "首页推荐（0不推荐，1推荐）")
    private Integer isRecommend;

//    @ApiModelProperty(value = "开始可售时间")
    private String startTime;

//    @ApiModelProperty(value = "结束可售时间")
    private String endTime;

//    @ApiModelProperty(value = "库存限制（1：限制库存, 2不限制库存）")
    private Integer stockLimit;

//    @ApiModelProperty(value = "用户限购类型（1不限制，2限制每人N件，3限制每人每天N件）")
    private Integer limitType;

//    @ApiModelProperty(value = "限购数量")
    private Integer limitNumber;

//    @ApiModelProperty(value = "用户等级限制（1不限制，2限制会员等级，3付费会员，4非付费会员）")
    private Integer levelType;

//    @ApiModelProperty(value = "会员等级列表")
//    private List<Object> levelList;

//    @ApiModelProperty(value = "商品排序值")
    private Integer sequence;

//    @ApiModelProperty(value = "分类排序值")
    private Integer categorySequence;

//    @ApiModelProperty(value = "商品状态（1下架，2上架，3售罄，4不在可售时间内，5超过每人总限购数量，6超过每人每天限购数量，7用户等级不足，8用户身份不足）")
    private Integer status;

//    @ApiModelProperty(value = "实物商品信息")
    private EntityProductType entityProductInfo;

//    @ApiModelProperty(value = "剩余库存数量")
    private Integer stockNumber;

//    @ApiModelProperty(value = "已兑换数量")
    private Integer exchangeNumber;

}
