package cn.freemud.entities.dto.order;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
public class OrderInvoiceResponse {

    @ApiModelProperty("主键")
    private Integer id;

    @ApiModelProperty("商户号")
    private String partnerId;

    @ApiModelProperty("渠道类型")
    private String channelType;

    @ApiModelProperty("渠道名称")
    private String channelName;

    @ApiModelProperty("税号")
    private String taxNo;

    @ApiModelProperty("发票类型,{4-增值税专用发票,7-增值税普通发票,26-增值税电子发票,25-增值税卷式发票,28-增值税专用电子发票}")
    private Integer invoiceType;

    @ApiModelProperty("appKey")
    private String appKey;

    @ApiModelProperty("appSercret")
    private String appSercret;

    @ApiModelProperty("token")
    private String token;

    @ApiModelProperty("userName")
    private String userName;

    @ApiModelProperty("password")
    private String password;

    @ApiModelProperty("盐值，加密盐")
    private String salt;

    @ApiModelProperty("发票说明")
    private String remark;

    @ApiModelProperty("状态 0启用 1禁用")
    private Integer state;

    @ApiModelProperty(value = "税收分类编码")
    private String productCode;

    @ApiModelProperty(value = "商品名称")
    private String productName;

    @ApiModelProperty("税率")
    private String taxRate;

    @ApiModelProperty("发票内容")
    private String content;

}
