package com.freemud.sdk.api.assortment.shoppingcart.constant;

public enum CollageMemberStateType {
    READY(true, "加购完毕"),
    SHOPPING(false, "正在选购");

    private Boolean value;

    private String desc;

    CollageMemberStateType(Boolean value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static CollageMemberStateType getByValue(Object value) {
        try {
            return Boolean.parseBoolean(String.valueOf(value)) ? CollageMemberStateType.READY : CollageMemberStateType.SHOPPING;
        } catch (ClassCastException e) {
            return CollageMemberStateType.SHOPPING;
        }
    }

    public Boolean getValue() {
        return value;
    }

    public void setValue(Boolean value) {
        this.value = value;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
