package cn.freemud.entities.db;

import lombok.Data;

import javax.persistence.*;
import java.util.Date;

@Data
@Table(name = "open_platform_payment_config")
public class OpenPlatformPaymentConfig {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * appid
     */
    @Column(name = "wx_appid")
    private String wxAppId;

    /**
     * 商户号
     */
    @Column(name = "partner_id")
    private String partnerId;

    /**
     * 客户端id
     */
    @Column(name = "client_code")
    private Integer clientCode;

    /**
     * 平台账户id
     */
    @Column(name = "platform_accountid")
    private Integer platformAccountId;

    /**
     * 支付方式
     */
    @Column(name = "pay_code")
    private String payCode;

    /**
     * 微信支付商户号
     */
    @Column(name = "mch_id")
    private String mchId;

    /**
     * 创建时间
     */
    @Column(name = "gmt_created")
    private Date gmtCreated;

    /**
     * 修改时间
     */
    @Column(name = "gmt_modified")
    private Date gmtModified;
}