/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: ShoppingCartUpdateRequestVo
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: ping.wu
 * @date: 2018/5/22 10:42
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.vo;

import lombok.Builder;
import lombok.Data;

import java.util.List;

@Data
public class ShoppingCartGoodsResponseVo  extends ShoppingCartGoodsBaseResponseVo{

    /**
     * 商品额外的属性
     */
    List<CartGoods> products;
    /**
     * 商品总数
     */
    private Integer productsCount;
    /**
     * 活动信息
     */
    private ActivityTip activityTip;

    /**
     * 原总价
     */
    private Long originalTotalAmount;
    /**
     * 现总价
     */
    private Long totalAmount;
    /**
     * 总折扣价
     */
    private Long totalDiscountAmount;

    /**
     * 新包装费（该字段给新版本前端展示，使其好计算）
     */
    private Long newPackAmount;

    /**
     * 优惠券折扣
     */
    private Long couponDiscount;

    /**
     * 满减折扣
     */
    private Long fullDiscount;
    /**
     * svc卡支付描述
     */
    private String svcDiscountDesc;

    /**
     * 可用优惠券列表
     */
    private ActivityClassifyCouponBean availableCoupon;

    private ActivityTip buyOneGetActivity;
    /**
     * 积分抵扣优惠
     */
    private ShoppingCartCustomerScoreVo customerScoreVo;
    /**
     * 起送费
     */
    private Long freeDeliveryPrice;
    /**
     * 会员卡原价
     */
    private Integer cardOriginalAmount;

    /**
     * 会员卡优惠金额
     */
    private Integer cardDiscountAmount;

    /**
     * 配送费
     */
    private Long deliveryAmount;

    /**
     * 减免后配送费
     */
    private Long discountDeliveryAmount;

    /**
     * 满多少额度 减免
     */
    private Long thresholdAmount;

    /**
     * 是否参加满额减免
     */
    @Builder.Default
    private Boolean isDiscountDelivery = false;

    /**
     * 满额减配送费描述
     */
    private String deliveryDiscountDesc;

    /**
     * 减免后配送费
     */
    private String discountDeliveryActivityCode;

    /**
     * 配送费为零的原因：0:正常,1:超出配送范围
     */
    private Integer deliveryFeeZeroReason;

    /**
     * 代金券
     */
    private String couponCode;
}
