package com.freemud.sdk.api.assortment.shoppingcart.util;

import ch.qos.logback.classic.Level;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: ${FILE_NAME}
 * @Package com.freemud.base.log
 * @Description: 异常日志打印
 * @author: aiqi.gong
 * @date: 2017/6/21 10:43
 * @Copyright: 2017 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
public class ErrorLog {
    private static Logger logger = LoggerFactory.getLogger(com.freemud.application.sdk.api.log.ErrorLog.class);


    public static void infoConvertJson(String appName, String trackingNo, Class logClass, String message, Exception ex) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ex.printStackTrace(new PrintStream(baos));
        String exception = baos.toString();
        printLog(appName, trackingNo, logClass, message, exception, Level.INFO);
    }

    public static void errorConvertJson(String appName, String trackingNo, Class logClass, String message, Exception ex) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ex.printStackTrace(new PrintStream(baos));
        String exception = baos.toString();
        printLog(appName, trackingNo, logClass, message, exception, Level.ERROR);
    }

    public static void printLog(String appName, String trackingNo, Class logClass, String message, Exception ex, Level level) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ex.printStackTrace(new PrintStream(baos));
        String exception = baos.toString();
        printLog(appName, trackingNo, logClass, message, exception, level);
    }

    public static void printLog(String appName, String trackingNo, Class logClass, String message, Object object, Level level) {
        logger.info("appName:{} trackingNo:{} className{} level:{} messasge:{} stackTrack:{}", appName, trackingNo, logClass, level.levelStr, message, JSONObject.toJSONString(object));
    }

    public static void printErrorLog(String appName, String trackingNo, String message, String url, Object request, Exception ex, Level level) {
        logger.info("appName:{} trackingNo:{} level:{} messasge:{} url:{} requestBody:{} stackTrack:{}", appName, trackingNo, level.levelStr, message, url, JSONObject.toJSONString(request), JSONObject.toJSONString(ex));
    }

}
