package cn.freemud.demo.service;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.demo.entities.bo.goods.ShoppingCartGoodsBO;
import cn.freemud.demo.entities.bo.goods.*;
import cn.freemud.demo.entities.bo.goods.add.BaseAddGoodsBO;

public interface AddGoodsService {

    /**
     *
     * 检验客制化的参数
     * @param baseRequestDTO
     * @return
     */
    default BaseResponse checkCustomParams(BaseAddGoodsBO baseRequestDTO) {
        return ResponseBuilder.success();
    }


    /**
     * 获取购物车信息
     * @param baseRequestDTO
     * @return
     */
    default CheckBussinessRulesBO getShoppingCartInfo(BaseAddGoodsBO baseRequestDTO) {
        return new CheckBussinessRulesBO();
    }

    /**
     * 进行客制化的业务校验
     * @param baseRequestDTO
     * @return
     */
    default AddGoodsToShoppingCartBO checkCustomBusinessRules(BaseAddGoodsBO baseRequestDTO, CheckBussinessRulesBO checkBussinessRulesBO, AddGoodsToShoppingCartBO addGoodsToShoppingCartBO) {
        return addGoodsToShoppingCartBO;
    }



    /**
     * 购物车赋值
     * @param baseRequestDTO
     * @return
     */
    default DiscountResultBO customAddGoodsToShoppingCart(BaseAddGoodsBO baseRequestDTO, AddGoodsToShoppingCartBO addGoodsToShoppingCartBO, DiscountResultBO customCalCostBO) {
        return customCalCostBO;
    }



    /**
     * 进行客制化的计算费用
     * @param baseRequestDTO
     * @return
     */
    default DistributeBO calCustomCost(BaseAddGoodsBO baseRequestDTO, CalCostBO calCostBO, DistributeBO commonSetMessageBO) {
        return commonSetMessageBO;
    }

    default CalCostBO getDiscountResultBefore(BaseAddGoodsBO baseRequestDTO, DiscountResultBO calCostBO) {
        return new CalCostBO();
    }

    /**
     * 客制化优惠计算
     * @param baseRequestDTO
     * @return
     */
    default CalCostBO getDiscountResultAfter(BaseAddGoodsBO baseRequestDTO, DiscountResultBO calCostBO, CalCostBO commonSetMessageBO) {
        return commonSetMessageBO;
    }

    /**
     * 客制化优惠响应
     * @param baseRequestDTO
     * @return
     */
    default SetMessageBO customDistribute(BaseAddGoodsBO baseRequestDTO, DistributeBO calCostBO, SetMessageBO commonSetMessageBO) {

        return commonSetMessageBO;
    }

    /**
     * 客制化信息提醒
     * @param baseRequestDTO
     * @return
     */
    default ShoppingCartGoodsBO setCustomMessage(BaseAddGoodsBO baseRequestDTO, SetMessageBO setMessageBO, ShoppingCartGoodsBO shoppingCartGoodsBO) {
        return shoppingCartGoodsBO;
    }


}
