package com.freemud.application.sdk.api.ordercenter.entities.extinfo;

import lombok.Data;
import org.apache.commons.lang.StringUtils;

@Data
public class ProductGroupVo {


    /**
     * 商品组id。非码商品组ID唯一
     */
    private String groupId;

    /**
     * 商品组名称
     */
    private String groupName;

    /**
     * 第三方商品组编码。后台人工录入，有可能不唯一。
     */
    private String thirdGroupId;

    @Override
    public int hashCode() {
        StringBuilder sb = new StringBuilder();
        sb.append(groupId).append(thirdGroupId).append(groupName);
        return sb.toString().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (o == null || getClass() != o.getClass())
            return false;

        // 原始字符串
        StringBuilder originalString = new StringBuilder();
        originalString.append(groupId).append(thirdGroupId).append(groupName);


        //当前字符串
        ProductGroupVo groupVo = (ProductGroupVo) o;

        StringBuilder currentString = new StringBuilder();
        currentString.append(groupVo.groupId).append(groupVo.thirdGroupId).append(groupVo.groupName);

        return StringUtils.equals(originalString.toString(), currentString.toString());
    }
}
