package cn.freemud.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum InvoiceTypeCodeEnum {

    SPECIAL_INVOICE(4, "004", "增值税专用发票"),
    COMMON_INVOICE(7, "007", "增值税普通发票"),
    ELECTRONIC_INVOICE(26, "026", "增值税电子发票"),
    ROLL_INVOICE(25, "025", "增值税卷式发票"),
    SPECIAL_ELECTRONIC_INVOICE(28, "028", "增值税专用电子发票"),


    ;

    /**
     * 非码类型
     */
    private Integer fmType;

    /**
     * 百望类型
     */
    private String bwType;
    private String desc;

    /**
     * 根据fmType获取bwType
     * @param fmType
     * @return
     */
    public static String getBwType(Integer fmType){
        for (InvoiceTypeCodeEnum value : InvoiceTypeCodeEnum.values()) {
            if (value.getFmType().equals(fmType)) {
                return value.getBwType();
            }
        }
        return null;
    }

    /**
     * 根据fmType获取bwType
     * @param bwType
     * @return
     */
    public static Integer getFmType(String bwType){
        for (InvoiceTypeCodeEnum value : InvoiceTypeCodeEnum.values()) {
            if (value.getBwType().equals(bwType)) {
                return value.getFmType();
            }
        }
        return null;
    }
}
