package cn.freemud.entities.dto.order;

import lombok.Data;

import java.util.List;

@Data
public class McCafePushOrderDto {
    //小程序订单ID
    private String mpOrderId;
    //对接iRMS业务ID
    private String displayOrderId;
    //订单类型-枚举 1: 堂食 2: 外卖
    private String type;
    //销售类型-枚举 1: 即时单 2: 预约单
    private String saleType;
    //用餐类型-枚举 1: 堂食 2: 外带 3: 得来速 4: 取餐柜
    private String eatType;
    //配送类型-枚举 1: MDS
    private String deliveryType;
    //订单来源-枚举 APP: CMA WEB: WOS MT: 美团 ELE: 饿了么 WXMP: 微信小程序 ALIMP: 支付宝小程序
    private String sourceType;
    //业务类型枚举 1: FC母店 2: MDS麦乐送 3: McCafe麦咖啡 4: Kiosk甜品站
    private String beType;
    //餐段标识枚举 1: 早餐 2: 正餐
    private String dayPart;
    //渠道枚举 07: 微信小程序Pickup 08: 支付宝小程序Pickup 09: 微信小程序MDS 10:麦咖啡微信小程序
    private String channel;
    //订单状态枚举 10: 待支付 20: 已支付 30: 餐厅已确认 31: 餐厅配餐中（pickup） 32: 订单配送中 33: 餐厅配餐中（delivery） 34: 待用户取餐(取餐柜) 40: 订单已完成 60: 已取消 61: 取消审核中 80: 已退款
    private String status;
    //是否需要发票 0: 不需要 1: 需要
    private Integer invoiceNeeded;
    //是否已开票 0: 未开票 1: 已发票
    private Integer Invoiced;
    //用户MeddyId
    private String customer_id;
    //期望配送时间: yyyy-MM-dd hh:mi:ss
    private String expectDeliveryTime;
    //平台来源枚举 1: Android 2: IPhone
    private String platformSource;
    //门店编码
    private String storeCode;
    //门店名称
    private String storeName;
    //门店营业日期 yyyy-MM-dd
    private String businessDate;
    //餐具需求 01: 需要 02: 不需要
    private String tablewareInfo;
    //订单应收金额
    private Integer totalAmount;
    //订单税额金额
    private Integer taxTotalAmount;
    //订单折扣金额
    private Integer discountTotalAmount;
    //订单实收金额
    private Integer realTotalAmount;
    //运费原始金额
    private Integer deliveryPrice;
    //运费实际金额
    private Integer realDeliveryPrice;
    //备注
    private String remark;
    //销售时间 yyyy-MM-dd HH:mm:ss
    private String saleTime;
    //完成时间 yyyy-MM-dd HH:mm:ss
    private String completionTime;
    //订单取消原因Code枚举 1: 改主意了 2: 重复下单 3: 点错了/点多了/点少了 4: 地址/电话填错了 5: 送达时间选错了 -1: 其它原因 100: 超时未支付，自动取消 101: 订单入机失败，自动取消 102: 订单推送IRMS失败，自动取消订单
    private String cancellationReasonCode;
    //订单取消评论
    private String cancellationRemark;
    //接单时间 yyyy-MM-dd HH:mm:ss.SSS
    private String acceptTime;
    //取餐码
    private String pickupCode;
    //用户三方ID
    private String openId;
    //UNION ID
    private String unionId;
    //yyyy-MM-dd HH:mm:ss
    private String createdDate;
    //订单项
    private List<OrderItem> orderItem;
    //订单支付
    private List<OrderPayment> orderPayment;
    //订单配送
    private OrderDelivery orderDelivery;
    //订单地址
    private OrderAddress orderAddress;
    //订单入机
    private List<OrderFoe> orderFoe;


    @Data
    public static class OrderItem {
        //订单项ID
        private String mpItemId;
        //订单项序号
        private String sequenceId;
        //轮次序列号
        private String round;
        //父项ID
        private String mpParentItemId;
        //商品类型枚举 1: 单品 2: 套餐 3: 组合商品 4: 配送费 99: 餐具费 101: Oh麦卡
        private String productType;
        //商品CODE
        private String productCode;
        //商品属性列表
        private List<productAttribute> productAttribute;
        //商品名称
        private String productName;
        //商品长名称
        private String productLongName;
        //商品名称英文
        private String productNameEn;
        //商品长名称英文
        private String productLongNameEn;
        //订单项数量
        private String quantity;
        //订单项实际数量
        private String real_quantity;
        //订单项键位价格
        private String original_price;
        //订单项原始价格
        private String price;
        //订单项原始金额小计
        private String subtotal;
        //订单项优惠金额小计
        private String discountAmount;
        //订单项实际金额小计
        private String realAmount;
        //订单项税额小计
        private String taxAmount;
        //订单项税额明细(单品和套餐/组合商品的父项)
        private List<TaxAmountDetail> taxAmountDetail;
        //订单项税ID
        private String taxId;
        //订单项税率: 6,12
        private String taxRate;
        //是否成本包含（套餐子项使用） 0: 套餐成本不包含当前子项 1: 套餐成本包含当前子项 空: 套餐父项
        private String costInclusive;
        //创建时间 yyyy-MM-dd HH;mm:ss
        private String createdDate;

    }

    @Data
    public static class productAttribute {
        //特调编号
        private String grillCode;

        //商品特调列表
        private List<GrillItem> grillItemList;

        //特调中文
        private String grillNameCn;
        //特调中文
        private String grillNameEn;
        //特调税额
        private String taxAmount;
        //特调税费ID
        private String taxId;
        //特调税率
        private String taxRate;
    }

    @Data
    public static class GrillItem {
        //特调编码
        private String grillItemCode;
        //特调中文
        private String grillItemNameCn;
        //特调英文
        private String grillItemNameEn;
        //特调价格
        private String grillItemPrice;
        //是否修改
        private String isModify;
        //特调数量
        private String quantity;

    }

    @Data
    public static class TaxAmountDetail {
        //订单项商品编号
        private String uniqueCode;
        //税费明细
        private List<TaxItem> taxItems;

    }

    @Data
    public static class TaxItem {
        //实际金额(分为单位)
        private Integer realAmount;
        //税额(分为单位)
        private Integer taxAmount;
        //税费ID
        private String taxId;
        //税率(6/12)
        private String taxRate;

    }

    @Data
    public static class OrderPayment {
        //支付交易ID
        private String channelPayTransactionId;
        //支付状态-枚举 UNPAID: 未支付 PAYING: 支付中 PAID: 支付成功 FAILED 支付失败 CLOSE 支付关闭
        private String payStatus;
        //订单来源枚举 07: 微信小程序Pickup 08: 支付宝小程序pickup 09: 微信小程序MDS 10:麦咖啡微信小程序
        private String paySource;
        //支付渠道枚举 ALI: 支付宝 WX: 微信支付 ARCHCARD: 麦钱包
        private String payChannel;
        //支付金额
        private Integer payAmount;
        //退款类型枚举 1: 整单退款
        private String refundType;
        //退款金额
        private Integer refundAmount = 0;
        //退款时间 yyyy-MM-dd HH:mm:ss
        private String refundTime;
        //退款原因
        private String refundReason;
        //支付标记类型0-非预付券,1-预付券
        private String signType;
        //订单目的01-充值,02-消费
        private String payPurpose;
        //消费类型 01: pickup, 02: delivery pay_purpose为02,必传
        private String consumeType;
        //pay_purpose为02,必传
        private String tenderCode;
        //支付网关-支付订单号
        private String upgPayInstructionId;
        //支付网关-支付订单号
        private String upgPayOrderId;
        //支付状态枚举 REFUNDED: 已退款
        private String refundStatus;
        //退款交易ID
        private String channelRefundTransactionId;
        //支付网关-退款指令号
        private String upgRefundInstructionId;
        //支付网关-退款订单号
        private String upgRefundOrder_id;
        //创建时间 yyyy-MM-dd HH:mm:ss
        private String createdDate;

    }

    @Data
    public static class OrderDelivery {
        //配送状态枚举 accept:接单 assembly: 汇集订单 intransit: 配送订单 completed: 完成订单
        private String status;
        //骑手昵称
        private String riderNickName;
        //骑手手机号
        private String riderMobileNo;
        //派单时间 yyy-MM-dd HH:mm:ss
        private String dispatchTime;
        //接单时间yyy-MM-dd HH:mm:ss
        private String acceptTime;
        //汇合时间yyy-MM-dd HH:mm:ss
        private String assemblyTime;
        //配送中时间yyy-MM-dd HH:mm:ss
        private String transitTime;
        //完成时间yyy-MM-dd HH:mm:ss
        private String completedTime;
        //骑手备注
        private String remark;
        //创建时间yyy-MM-dd HH:mm:ss
        private String createdDate;

    }

    @Data
    public static class OrderAddress {
        //渠道枚举 01: CMA 5 02: WOS 03: CMA 6 04: NEW WEB 19: 美团 20: 饿了么 45: 微信小程序 54: 支付宝小程序 10:麦咖啡微信小程序
        private String channel;
        //用户账号-MeddyId
        private String customerId;
        //昵称
        private String customerNickName;
        //性别枚举 1: 男 2: 女
        private String gender;
        //手机号
        private String phone_no;
        //省份-麦中码表 江苏省: 320000
        private String provinceCode;
        //城市-字典表配置 苏州市: 320500
        private String cityCode;
        //区域-字典表配置 吴中区: 320506
        private String districtCode;
        //地址-地图定位地址 新桥商务中心
        private String address;
        //详细地址-用户输入 B栋701
        private String detail;
        //经度
        private String longitude;
        //纬度
        private String latitude;
        //创建时间yyy-MM-dd HH:mm:ss
        private String createdDate;

    }

    @Data
    public static class OrderFoe {
        //入机生成的外部订单ID
        private String foeOrderKey;
        //门店编码
        private String storeCode;
        //订单类型枚举 1: 堂食 2: 外卖
        private String orderType;
        //取餐码
        private String pickupCode;
        //入机状态枚举 10: 未入机 20: 入机成功 30: 入机失败
        private String status;
        //入机状态描述 status=30时, status description存储入机失败原因
        private String statusDescription;
        //入机类型 1: 正向单 2: 负向单
        private String foeType;
        //创建时间yyy-MM-dd HH:mm:ss
        private String createdDate;

    }


}
