/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderCallBackConfig
 * @Package cn.freemud.amp.config
 * @Description:
 * @author: ping.wu
 * @date: 2019/4/16 14:16
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.amp.config;

import cn.freemud.amp.service.OrderCallBackMQService;
import org.springframework.amqp.core.*;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;

public class OrderCallBackConfig {

    public static final String EXCHANGE_NAME = "call-back-service-topic-exchange";
    public static final String QUEUE_NAME = "order-call-back-queue";
    public static final String QUEUE_ROUTING_KEY = "order-call-back-queue-routing-key";

    ///开放平台
    public static final String TOPIC_EXCHANGE_NAME = "topic-Exchange";
    public static final String OPEN_PLATFORM_ORDER_STATUS_CHANGE_PUSH_QUEUE_NAME = "open-platform-order-status-change-push-queue";
    public static final String OPEN_PLATFORM_ORDER_STATUS_CHANGE_PUSH_ROUTING_KEY = "open-platform-order-status-change-routing-key";

    public static final String WECHAT_REPORT_QUEUE_ROUTING_KEY = "wechat-report-queue-routing-key";
    //微信订单上传
    public static final String WECHAT_ORDER_REPORT_QUEUE_ROUTING_KEY = "wechat-order-report-queue-routing-key";
    public static final String WECHAT_ORDER_REPORT_QUEUE = "wechat-order-report-queue";

    public static final String INVOICE_QUEUE = "invoice-report-queue";
    public static final String INVOICE_ROUTE_KEY = "invoice-report-queue-routing-key";

    // 腾讯有数上报 & 门店营业开店记录  发送到 ordercenter-order组的 mq中
    @Deprecated
    public static final String SEND_YOUSHU_REPORT_QUEUE_ROUTING_KEY = "send-youshu-report-queue-routing-key";
    @Deprecated
    public static final String SEND_YOUSHU_REPORT_QUEUE = "send-youshu-report-queue";


    // task-center-order-consumer服务 订单状态处理中心queue
    public static final String ORDER_STATUS_PROCESS_CENTER_QUEUE_ROUTING_KEY = "order_status_process_center_queue-routing-key";
    public static final String ORDER_STATUS_PROCESS_CENTER_QUEUE = "order_status_process_center_queue";

    // 支付宝订单状态推送　tapd需求id 1032865
    public static final String ZFB_ORDER_SEND_QUEUE_ROUTING_KEY = "zfb-order-send-queue-routing-key";
    public static final String ZFB_ORDER_SEND_QUEUE = "zfb-order-send-queue";

    /**
     * 定义基于Fanout 的Exchange。
     * 基于这个代码，也可以非常方便的定义其他的Exchange类型。
     *
     * @return Fanout Exchange
     */
    @Bean
    public Exchange exchange() {
        return ExchangeBuilder.topicExchange(EXCHANGE_NAME).durable(true).build();
    }

    /**
     * 写入RabbitMQ使用的默认队列
     *
     * @return
     */
    @Bean
    public Queue pushOrderQueue() {
        return QueueBuilder.durable(QUEUE_NAME).build();
    }

    /**
     * 绑定消息队列
     *
     * @param pushOrderQueue 消息队列
     * @param exchange       RabbitMQ Fanout Exchange
     * @return 消息队列绑定
     */
    @Bean
    Binding bindingMail(Queue pushOrderQueue, Exchange exchange) {
        return BindingBuilder.bind(pushOrderQueue).to(exchange).with(QUEUE_ROUTING_KEY).noargs();
    }

    @Bean(name = "topicExchange")
    public Exchange topicExchange() {
        return ExchangeBuilder.topicExchange(TOPIC_EXCHANGE_NAME).durable(true).build();
    }

    @Bean(name = "orderStatusChangeQueue")
    public Queue orderStatusChangeQueue() {
        return QueueBuilder.durable(OPEN_PLATFORM_ORDER_STATUS_CHANGE_PUSH_QUEUE_NAME).build();
    }

    @Bean
    Binding bindingOrderStatus(@Qualifier("orderStatusChangeQueue") Queue orderStatusChangeQueue, @Qualifier("topicExchange") Exchange topicExchange) {
        return BindingBuilder.bind(orderStatusChangeQueue).to(topicExchange).with(OPEN_PLATFORM_ORDER_STATUS_CHANGE_PUSH_ROUTING_KEY).noargs();
    }

    @Bean(name = "wechatOrderReportQueue")
    public Queue wechatOrderReportQueue() {
        return QueueBuilder.durable(WECHAT_ORDER_REPORT_QUEUE).build();
    }

    @Bean
    Binding bindingWechatOrderReportQueue(@Qualifier("wechatOrderReportQueue") Queue wechatOrderReportQueue, @Qualifier("topicExchange") Exchange topicExchange) {
        return BindingBuilder.bind(wechatOrderReportQueue).to(topicExchange).with(WECHAT_ORDER_REPORT_QUEUE_ROUTING_KEY).noargs();
    }

    @Bean
    public OrderCallBackMQService orderMQService() {
        return new OrderCallBackMQService();
    }

    /**
     * 发票queue绑定设置
     *
     * @return
     */
    @Bean(name = "invoiceExchange")
    public Exchange invoiceExchange() {
        return ExchangeBuilder.topicExchange(TOPIC_EXCHANGE_NAME).durable(true).build();
    }

    @Bean(name = "invoiceQueue")
    public Queue invoiceQueue() {
        return QueueBuilder.durable(INVOICE_QUEUE).build();
    }

    @Bean
    Binding bindingInvoiceQueue(@Qualifier("invoiceQueue") Queue invoiceQueue, @Qualifier("invoiceExchange") Exchange invoiceExchange) {
        return BindingBuilder.bind(invoiceQueue).to(invoiceExchange).with(INVOICE_ROUTE_KEY).noargs();
    }

    /**
     * 有数上报/ 支付门店 queue 绑定
     *
     * @return
     */
    @Bean(name = "sendWechatReportQueue")
    public Queue sendWechatReportQueue() {
        return QueueBuilder.durable(SEND_YOUSHU_REPORT_QUEUE).build();
    }

    @Bean
    Binding bindingSendWechatReportQueue(@Qualifier("sendWechatReportQueue") Queue sendWechatReportQueue, @Qualifier("topicExchange") Exchange topicExchange) {
        return BindingBuilder.bind(sendWechatReportQueue).to(topicExchange).with(SEND_YOUSHU_REPORT_QUEUE_ROUTING_KEY).noargs();
    }


    /**
     * 有数上报/ 支付门店 queue 绑定
     *
     * @return
     */
    @Bean(name = "orderStatusProcessCenterQueue")
    public Queue orderStatusProcessCenterQueue() {
        return QueueBuilder.durable(ORDER_STATUS_PROCESS_CENTER_QUEUE).build();
    }

    @Bean
    Binding bindingOrderStatusProcessCenterQueue(@Qualifier("orderStatusProcessCenterQueue") Queue orderStatusProcessCenterQueue, @Qualifier("topicExchange") Exchange topicExchange) {
        return BindingBuilder.bind(orderStatusProcessCenterQueue).to(topicExchange).with(ORDER_STATUS_PROCESS_CENTER_QUEUE_ROUTING_KEY).noargs();
    }
}
