package com.freemud.application.sdk.api.ordercenter.request;

import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * 售后单分页条件查询请求
 */
@Data
public class QueryAfterSalesOrderConditionsReq {
    // "商户号",required = true)
    private String partnerId;

    // "售后单编号")
    private String afterSalesCode;

    // "门店编号")
    private List<String> storeIds = new ArrayList<>();

    // "三方订单号")
    private String thirdOrderCode;

    // "订单编号")
    private String orderCode;

    // "客户电话")
    private String customerMobile;

    // OrderClientType.API_DESC)
    private List<Byte> orderClients;

    // "订单类型")
    private List<Integer> orderTypes = new ArrayList<>();

    // "配送类型 1自配送(三方渠道配送、商家店员配送) 2平台配送")
    private Byte expressType;

    // "订单创建开始时间戳")
    private Long startTimestamp;

    // "订单创建结束时间戳")
    private Long endTimestamp;

    // "售后单创建时间开始")
    private Long startAfterCreateTimestamp;

    // "售后单创建结束")
    private Long endAfterCreateTimestamp;

    // AfterSalesStatus.API_DESC)
    private List<Byte> afterSalesStatusList;

    // OrderStatus.API_DESC)
    private List<Byte> orderStateList;

    // "第几页,从1开始，默认第1页")
    private Integer pageNum;

    // "每页条目数量，默认10条")
    private Integer pageSize;

    //售后单阶段类型 1:售前 2:售中 3:售后
    private Byte afterSalesStageType;

    protected Integer ver;

    private List<Integer> bizTypes;
}
