package cn.freemud.fuyou.feign.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 * All rights Reserved,Designed By www.freemud.cn
 *
 * @Title:ScorePayRequest
 * @package cn.freemud.customer.microservice.propertymicro.vo.req
 * @Description:${TODO}(用一句话描述该文件做什么)
 * @Author:xiaofeng.han
 * @Date:2019/5/13 14:12
 * @Version V1.0
 * @Copyright:2018www.freemud.cn Inc.All rights reserved. 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目的
 */
@Data
public class ScorePayRequest extends BaseIdempotencyRequest {

    @ApiModelProperty(value = "会员编号", required = true)
    @NotBlank(message = "会员编号不能为空")
    private String memberId;

    @ApiModelProperty(value = "变动积分", required = true)
    @NotNull(message = "变动积分不能为空")
    @Min(value = 1, message = "变动积分必须为大于等于1的正整数")
    private Integer changeScore;

    @ApiModelProperty(value = "操作类型{1消费送积分2积分支付退回3积分签到4手动赠送5等级升级送积分6割接7生日送8注册送9完善送10消费满赠11手动扣减12积分兑换13积分清理14积分支付15消费送积分扣回16等级升级退积分17消费满赠扣回}", required = true)
    @NotNull(message = "操作类型不能为空")
    private Integer operationType;

    @ApiModelProperty("操作名称{1消费送积分2积分支付退回3积分签到4手动赠送5等级升级送积分6割接7生日送8注册送9完善送10消费满赠11手动扣减12积分兑换13积分清理14积分支付15消费送积分扣回16等级升级退积分17消费满赠扣回}")
    private String operationName;

    @ApiModelProperty("订单编号")
    private String orderId;

    @ApiModelProperty("机构编码")
    private String orgCode;

    @ApiModelProperty("机构类型{1总公司2分公司3门店}")
    private Integer orgType;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("子品牌编号")
    private String subBrandCode;

    @ApiModelProperty("是否查询子品牌积分规则")
    private Boolean isGetSubBrandRule = false;

}
