package cn.freemud.entities.dto.promotion;

import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.util.List;

@Data
public class CalculationDiscountRequestDto {

    /**
     * 版本号
     */
    @NotNull(message = "ver不能为空")
    private Integer ver;

    /**
     * 用户id，用于优惠券优惠金额计算
     */
    private String userId;

    /**
     * 是否是新用户
     */
    private Short isNewUser;

    private String storeId;

    /**
     * 组织ID集合
     */
    private List<String> orgIds;

    @NotNull(message = "不可为空")
    private String partnerCode;

    /**
     * 区域
     */
    private String area;

    /**
     * 配送费
     */
    private Integer distributionFee;

    /**
     * 绑定的小程序id
     */
    private String appId;

    @Valid
    @NotEmpty(message = "不可为空")
    private List<CalculationDiscountGoodsDto> goods;

    private List<CalculationCouponDto> coupons;

    private String channel;

    private String application;

    private String memberLevel;

    private String customerLabel;

    /**
     * 消费积分0
     */
    private Integer consumptionPoints;

    /**
     * 临时取消的活动号集合
     * @return
     */
    List<String> cancelActivityCodes;

    /**
     * 已选换购商品集合
     */
    @Valid
    private List<CalculationSendGoodsReqVO> sendGoods;

    /**
     * 商品渠道 查询商品信息时用
     * saas-自提 saasdelivery-外卖  saasmall-微商城 ....
     */
    private String productChannel;

    /**
     * 拼团活动是，必传活动号
     */
    private List<String> groupActivityCode;
}
