/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: CreateOrderProductDto
 * @Package cn.freemud.entities.dto
 * @Description: 订单商品列表
 * @author: liming.guo
 * @date: 2018/5/18 16:56
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.dto.order;

import lombok.Data;

import java.util.List;

/**
 *
 * {
 "accounts": [],
 "address": "堂食/自提",
 "amount": 4200,
 "companyId": "30b5f0ca-399a-4be3-9063-12a3d2622a38",
 "invoiceInfo": "是",
 "latitude": 31.370109,
 "longitude": 121.257151,
 "payChannel": "10007",
 "payStatus": 1,
 "payType": 1,
 "phone": "13817445653",
 "products": [{
 "customerCode": "123467822",
 "ignoreProductPrice": 0,
 "number": 1,
 "opid": "1",
 "price": 4600,
 "productId": "502954",
 "productName": "法式珍虾厚牛堡中套餐",
 "sequence": 0,
 "specification": "",
 "discountList": [{
 "discountId": "2343232333",
 "discountDesc": "第二件半价",
 "discountType": "23",
 "discountAmount": 500,
 "customerCode": "string",
 "addInfo": "string"
 }]
 }],
 "remark": "sdsdsf",
 "shopId": "1450100",
 "shopName": "上海麦当劳沪宜餐厅",
 "status": 2,
 "takeAddress": "上海市嘉定区嘉定沪宜路3145号",
 "type": 5,
 "userId": "MEDDY947183194235654132",
 "userName": "文顺"
 }
 */
@Data
public class CreateOrderProductDto {
    /**
     * 商品
     */
    private String productId;
    /**
     * 商品名称
     */
    private String productName;
    /**
     * 商品数量
     */
    private Integer number;
    /**
     * 商品规格
     */
    private String specification;
    /**
     * 商品规格名称
     */
    private String specificationName;
    /**
     * 第三方商品编号 不可重复
     */
    private String customerCode;
    /**
     * 商品货号，可重复
     */
    private String productCode;

    /**
     * 商品价格 单价分
     */
    private Long price;
    /**
     * 实际销售价
     */
    private Long salePrice;
    /**
     * 商品图片
     */
    private String picture;
    /**
     * 排序
     */
    private Integer sequence;
    /**
     * 父商品ID，只有附加商品需要 非必填
     */
    private String parentProduct;
    /**
     * 父商品序号，只有附加商品需要 非必填
     */
    private Integer parentSequence;
    /**
     *  商户序号
     */
    private Integer opid;
    /**
     * 属性 温|半糖|甜
     */
    private String addInfo;
    /**
     *  属性
     */
    private String extras;
    /**
     * 商品所属菜单分类id
     */
    private String categoryId;
    /**
     * 商品所属菜单分类名称
     */
    private String categoryName;

    /**
     * 每行商品实际的优惠信息 V.1.5.2增加
     */
    public List<ProductDiscount> discountList;

    /**
     * 设置为1标识1.5.2版本以后新订单，影响B端订单详情显示 1.5.2增加
     */
    private Integer ignoreProductPrice;
    /**
     * 是否是库存商品
     */
    private Boolean hasStockProudct;
    /**
     * 商品行优惠总金额=数量*单个商品优惠金额
     */
    private Integer totalDiscountAmount;

    /**
     * 每行商品实际的优惠信息 V.1.5.2增加
     */
    @Data
    public static class ProductDiscount {

        /**
         * 存放活动ID ，couponCode
         */
        private String discountId;
        /**
         * 存放活动名称，券名称
         */
        private String discountDesc;
        /**
         * 存放活动类型 OrderAccountType 枚举
         */
        private Integer oldOrderAccountType;
        /**
         * 特价
         */
        private Long discountPrice;
        /**
         * 享受特价数量
         */
        private Integer discountQty;
        /**
         * 优惠金额 正数
         */
        private Long discountAmount;
        /**
         * 活动子code
         */
        private String customerCode;
        /**
         * 活动自定义信息
         */
        private String addInfo;

        private String productId;

    }



}
