package cn.freemud.interceptor;

import cn.freemud.enums.ResponseResult;
import com.freemud.application.sdk.api.exception.IgnoreErrorAnnotation;

/**
 * 自定义服务异常抛出
 * message 错误信息
 */
@SuppressWarnings("serial")
@IgnoreErrorAnnotation
public class ServiceException extends RuntimeException {

    private ResponseResult result;

    private String message;

    public ServiceException(ResponseResult result) {
        this.result = result;
        this.message = result.getMessage();
    }

    public ServiceException(ResponseResult result, String message) {
        this.result = result;
        this.message = message;
        this.result.setMessage(message);
    }

    public ResponseResult getResult() {
        return result;
    }

    public void setResult(ResponseResult result) {
        this.result = result;
    }

    @Override
    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}
