package cn.freemud.entities.dto;

import lombok.Data;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: BuriedPointRequestDto
 * @Package cn.freemud.entities.dto
 * @Description: 简单描述下这个类是做什么用的
 * @author: zhenghuan.yang
 * @date: 2018/9/25 15:21
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
public class BuriedPointRequestDto {
    private String ver; //版本号: 比如 1
    private String mcId; //商户号: 接入方定义
    private String unifyId; //非码统一商户号(目前按照统管平台标准)
    private String storeId; //门店号: 接入方定义
    private String uStoreId; //非码统一门店号(目前按照统管平台标准)
    private String appType; //埋点应用类型 (详细见埋点应用类型)
    private String appId; //商户埋点应用id: 接入方定义
    private String prePage; //上一页url: /homePage.html, 没有传空字符串
    private String curPage; //当前页url: /user/getInfo.html (见注意事项)
    private String pageTime; //用户当前页停留时间(单位:ms)
    private String event; //事件类型
    private String eventRes; //事件参数
    private String sessionId; //会话id
    private String uid; //会员系统用户id
    private String openId; //渠道用户id
    private String wxGender; //微信性别信息(微信授权用户信息获取: M-男,F-女,N-未知)
    private String phone; //手机号
    private String isNew; //是否新用户：1-是, 0-否
    private String screenWidth; //屏幕宽度
    private String screenHeight; //屏幕高度
    private String screenDesc; //屏幕分辨率
    private String screenIsH; //是否横屏: 1-是, 0-否
    private String os; //设备操作系统类型
    private String browser; //浏览器类型
    private String network; //网络环境
    private String ua; //userAgent
    private String devBrand; //设备品牌
    private String devMode; //设备型号
    private String devLang; //设备语言(小程序内是微信设置的语言)
    private String wxVer; //微信版本
    private String platform; //客户端平台
    private String ip; //终端 ip 地址
    private String ctime; //服务端事件触发时间 (yyyy-MM-dd HH:mm:ss)
    private Long ts; //服务端事件发生毫秒时间戳
    private String cts; //客户端事件发生毫秒时间戳
    private String env; //应用发布环境: 1-生产, 2-测试, 3-开发
    private String appFrom; //应用发布渠道: wxmp-微信小程序, h5, app
    private String adFrom; //推广渠道: 1-微信朋友圈 等
    private String pageRefer; //流量来源: 1-公众号推文, 2-朋友圈转发, 3-应用内打开
    private String mac; //终端mac地址
    private String prov; //省份
    private String city; //城市
    private String addr; //地址信息
    private String latitude; //纬度
    private String longitude; //经度
    private String devNo; //设备号
    private String isCrack; //设备是否破解(安卓root, iOS越狱): 1-是, 0-否
    private String opt1; //定义为传入 UPLOAD_TENCEN
    private String opt2; //大json，opt2的json格式如下（OptRequesDto）
}
