/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderItemCreateReq
 * @Package com.freemud.application.sdk.api.ordercenter.request
 * @Description:
 * @author: ping.wu
 * @date: 2019/4/1 19:52
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package com.freemud.application.sdk.api.ordercenter.request.create;

import lombok.Data;

@Data
public class OrderItemCreateReq {
    /**
     * 订单商品明细ID，由订单服务提供
     */
    private Long id;

    //商户号
    private String partnerId;

    //商品编号，商品服务唯一标识，SKU
    private String productId;

    //默认false，ignoreInOrderClose=false表示这个明细退完才能关单;ignoreInOrderClose=true表示这个明细没有退，但是该订单其他明细退完了就关单了
    private Boolean ignoreInOrderClose = false;

    //三方商品ID、SKU 商品服务唯一
    private String thirdProductId;

    //商品货号，商品服务可重复
    private String productCode;

    //父商品编号，主要用户组合商品
    private String parentProductId;

    //订单编号
    private String orderCode;

    //商品名称
    private String productName;

    //商品序号
    private Integer productSeq;

    //商品规格编号
    private String productSpec;

    //商品规格名称
    private String productSpecName;

    //商品UPC码
    private String productUpc;

    //购买数量
    private Integer productQuantity;

    //产品单位如份、杯
    private String productUnit;

    //商品单价
    private Long productPrice;

    //用户在界面上看到的支付金额，单位分
    private Long settlementPrice;

    //销售价格
    private Long salePrice;

    //优惠分摊金额
    private Long productSharePrice;

    //产品图片URL
    private String productPicUrl;

    //商品属性
    private String productProperty;

    //重量
    private Double weight;

    //重量单位
    private Byte productWeightUnit;

    // @ApiModelProperty(value = CanRefundType.API_DESC)
    private Boolean canRefund = true;

    //销售类型或营销活动类型 1普通订单 2秒杀订单 3推广活动
    private Byte marketingType;

    //活动ID
    private String marketingCode;

    //备注
    private String note;

    /**
     * 第三方商品分类
     */
    private String thirdCategoryId;
    //商品分类ID
    private String categoryId;

    //商品分类名称
    private String categoryName;

    //商品类型 --6
    private Integer productType;

    //商品明细扩展对象
    private String extInfo;

    // 是否删除
    private Boolean isDeleted;
    /**
     * 是否算积分
     * 线下订单上传专用
     */
    private Boolean needBonus;

    /**
     * 加购人ID
     */
    private String userId;

    /**
     * 加购人openId
     */
    private String openId;

    /**
     * 加购人昵称
     */
    private String nickName;

    /**
     * 加购人头像
     */
    private String photoUrl;

    /**
     * 加购人包装费
     */
    private Long packPrice;

}
