/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: RedisKeyConstant
 * @Package cn.freemud.constant
 * @Description: redisKey相关的常量
 * @author: song.cai
 * @date: 2018/12/17 12:48
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.constant;

import cn.freemud.utils.DateTimeUtil;

public class RedisKeyConstant {
    /**
     * userInfoMap的redisKey前缀
     */
    public final static String SAAS_USER_INFO_SESSIONID_KEY_PREFIX = "saas:user:info:sessionId:";
    /**
     * 手机号验证码的redisKey前缀
     */
    public final static String SAAS_VERIFICATION_CODE_KEY_PREFIX = "saas:userSmsCode:mobile_";
    /**
     * 用户购物车在redis的key前缀
     */
    public final static String SAAS_SHOPPINGCART_KEY_PREFIX = "saas:user:info:cart:";
    /**
     * 用户购物车总价在redis的key前缀
     */
    public final static String SAAS_SHOPPINGCART_AMOUNT_PREFIX = "saas:user:info:cart:amount:";
    /**
     * 商品的信息前缀
     */
    public final static String SAAS_GOODS_KEY_PREFIX = "saas:goods:";
    /**
     * 智慧推荐存商品在redis的key前缀
     */
    public final static String SAAS_USER_INFO_CNXH = "saas:user:info:cnxh:";
    /**
     * 校验用户登录白名单在redis的key前缀
     */
    public final static String SAAS_NOT_FILTER_URL = "saas:micro:exclude:url:";
    /**
     * 新版支付白名单在redis的key前缀
     */
    public final static String SAAS_MICRO_PAYMENT_PARTNER = "saas:micro:payment:partner:";

    /**
     * 支付回掉标记在redis的key前缀
     */
    public final static String KGD_PAYMENT_CALLBACK_FMID = "kgd:payment:callback:fmid:";

    /**
     * 点餐门店绑定的商城门店redis的key前缀
     */
    public final static String OPENSTORE_MICROMALL_BIND_STOREID_PREFIX = "openstore:micromall:bind:storeId:";

    /**
     * 商户订单支付超时时间设置key
     */
    public final static String PARTNER_PAY_OVERTIME = "partner_pay_overtime";

    /**
     * 积点前缀
     */
    public final static String KGD_SENDPOINT_ORDERID = "kgd:sendpoint:orderid:";


    private final static String REDIS_KEY_SEP = ":";


    /**
     * cocoNotMadeGoods:商户号:门店号:yyyy-MM-dd
     *
     * @param partnerId
     * @param storeId
     * @return
     */
    public static String notMadeGoodsNumber(String partnerId, String storeId) {
        StringBuilder sb = new StringBuilder("cocoNotMadeGoods");
        sb.append(REDIS_KEY_SEP);
        sb.append(partnerId).append(REDIS_KEY_SEP);
        sb.append(storeId).append(REDIS_KEY_SEP);
        sb.append(DateTimeUtil.getCurrentDateStr());
        return sb.toString();
    }

}
