package cn.freemud.service;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.vo.CreateOrderVo;
import cn.freemud.entities.vo.PaysuccessNoticeMessage;
import cn.freemud.entities.vo.encircle.CreateReserveOrderVo;
import cn.freemud.entities.vo.encircle.EmptyTableNumberVo;
import cn.freemud.entities.vo.encircle.EncircleReserveBaseVo;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.6.0
 * @Title: EncircleOrderService
 * @Description: 围餐订单业务类操作
 * @author: qin.zhou
 * @date: 2019/8/3022:47
 * @Copyright: ${DATE.YARE} www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
public interface EncircleOrderService {

    /**
     * 围餐--开台
     * @param createOrderVo
     * @return
     */
     BaseResponse createReserveOrder(CreateOrderVo createOrderVo);

    /**
     * 查询桌号是否开台
     * @return
     */
     BaseResponse queryTableNumberStatus(EncircleReserveBaseVo encircleReserveBaseVo);

    /**
     * 围餐--下单
     * @param createReserveOrderVo
     * @return
     */
    BaseResponse updateReserveOrder(CreateReserveOrderVo createReserveOrderVo);

    /**
     * 围餐--预览订单
     * @param createReserveOrderVo
     * @return
     */
    BaseResponse queryOrderInfo(CreateReserveOrderVo createReserveOrderVo);

    /**
     * 围餐--创建预支付订单
     * @param createReserveOrderVo
     * @return
     */
    BaseResponse createPrepaymentOrder(CreateReserveOrderVo createReserveOrderVo);

    /**
     * 清台
     * @param emptyTableNumberVo
     * @return
     */
    BaseResponse emptyTableNumber(EmptyTableNumberVo emptyTableNumberVo);

    /**
     * 围餐--svc卡支付预览订单
     * @param createReserveOrderVo
     * @return
     */
    BaseResponse previewOrderInfoSvcCheck(CreateReserveOrderVo createReserveOrderVo);
}
