package cn.freemud.service.customer;

import cn.freemud.entities.vo.CustomerInfoVo;
import cn.freemud.enums.ResponseResult;
import cn.freemud.interceptor.ServiceException;
import com.freemud.api.assortment.datamanager.entity.vo.AssortmentCustomerInfoVo;
import com.freemud.api.assortment.datamanager.manager.customer.AssortmentCustomerInfoManager;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

/**
 * @author Clover.z
 * @Date 2021/11/1
 * @Desc 会员信息通用能力下沉
 */
@Component
@RequiredArgsConstructor
public class CustomerInfoManager {

    private final AssortmentCustomerInfoManager assortmentCustomerInfoManager;

    /**
     * 获取登陆用户信息
     * @param sessionId
     * @return
     */
    public CustomerInfoVo getCustomerInfoVo(String sessionId) {
        AssortmentCustomerInfoVo info = assortmentCustomerInfoManager.getCustomerInfoByObject(sessionId);
        if (info == null) throw new ServiceException(ResponseResult.NOT_LOGIN);
        CustomerInfoVo customer = new CustomerInfoVo();
        BeanUtils.copyProperties(info, customer);
        return customer;
    }

}
