package cn.freemud.entities.vo;

import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.constraints.NotNull;

@Data
public class PremiumExchangeRequestVo {

    private String version;

    @NotEmpty(message = "partnerId不能为空")
    private String partnerId;

    @NotEmpty(message = "shopId不能为空")
    private String shopId;

    @NotEmpty(message = "用户会话sessionId不能为空")
    private String sessionId;

    /**
     * 订单类型  1 到店自取 2 外卖   枚举CreateOrderType
     */
    @NotNull(message = "orderType 不能为空")
    private Integer orderType;

    private String couponCode;
    /**
     * 优惠券的活动code
     */
    private String activityCode;

}
