package com.freemud.application.sdk.api.ordercenter.request;

import lombok.Data;

import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: OrderRefundQueryReq
 * @Package com.freemud.application.sdk.api.ordercenter.request
 * @Description:
 * @author: jiaxin.liu
 * @date: 2019/5/13 15:00
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
public class OrderRefundQueryReq {
    /**
     *下单时间结束
     */
    private String afterCreateTimeEnd;
    /**
     *下单时间开始
     */
    private String afterCreateTimeStart;
    /**
     *售后单编号
     */
    private String afterSalesCode;
    /**
     *售后单状态 1:待处理 2:退货中 3:拒绝退款 4:已退货 5:完成 6:取消
     */
    private List<Integer> afterSalesStatusList;
    /**
     *售后单类型 1:其他取消 2:用户取消 3:商户取消 4:未支付超时关单 5:商户接单超时取消 6:商家拒单 7:配送用户拒收 8:用户售后退货/售后退款 9:系统取消 10:客服取消 11:用户统一取消
     */
    private List<Integer> afterSalesTypeList;
    /**
     *下单时间结束
     */
    private String createTimeEnd;
    /**
     *下单时间开始
     */
    private String createTimeStart;
    /**
     *客户电话
     */
    private String customerMobile;
    /**
     *客户姓名
     */
    private String customerName;
    /**
     *配送类型 1自配送(三方渠道配送、商家店员配送) 2平台配送
     */
    private Integer expressType;
    /**
     *是否有退货
     */
    private Integer hasCargo;
    /**
     *操作人
     */
    private String operator;
    /**
     *排序字段
     */
    private String orderBy;
    /**
     * 下单渠道 1:自营微信小程序 2:SAAS,i应用 3:自营支付宝小程序 4:自营H5 5:自营安卓APP 6:自营苹果APP 7:自营PC-WEB 8:饿了么
     * 9:饿百 10:京东 11:美团外卖 12:自营APP 13:i应用会员 14:i应用订货 15:POS
     */
    private List<Integer> orderClients;
    /**
     *订单编号
     */
    private String orderCode;
    /**
     *订单状态 1:待支付 2:下单 3:已接单 4:制作完成(待发货) 5:配送中 6:已完 7:已关闭
     */
    private List<Integer> orderStateList;
    /**
     *第几页,从1开始，默认第1页
     */
    private Integer pageNum;
    /**
     *每页条目数量，默认10条
     */
    private Integer pageSize;
    /**
     *商户号
     */
    private String partnerId;
    /**
     *门店id
     */
    private String storeId;
    /**
     *目的门店
     */
    private List<String> toStoreIds;
    /**
     *用户id
     */
    private String userId;
    /**
     *版本号
     */
    private String ver;

}
